/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.inspect;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.fishstiz.minecraftcursor.inspect.ElementInspector;
import io.github.fishstiz.minecraftcursor.platform.Services;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public class ElementInspectorImpl
implements ElementInspector {
    private static final int DEEPEST_COLOR = -16711936;
    private static final int HOVERED_COLOR = -65536;
    private static final float Z = 900.0f;
    private static final float TEXT_SCALE = 0.75f;
    private HashSet<String> cache = new HashSet();
    private GuiEventListener hovered;
    private String hoveredName;

    @Override
    public void destroy() {
        this.cache.clear();
        this.cache = null;
        this.hovered = null;
        this.hoveredName = null;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean setHovered(GuiEventListener hovered, boolean cached) {
        this.hovered = hovered;
        this.hoveredName = this.getClassName(hovered);
        if (cached) {
            this.cache.add(this.hoveredName);
        }
        return true;
    }

    @Override
    public void renderDeepest(Minecraft minecraft, GuiGraphics guiGraphics, Screen screen, double mouseX, double mouseY) {
        GuiEventListener child = this.findDeepestChild((ContainerEventHandler)screen, mouseX, mouseY);
        GuiEventListener inspect = child != null ? child : screen;
        this.renderElement(guiGraphics, minecraft, inspect, -16711936, this.getClassName(inspect), true);
    }

    @Override
    public void renderHovered(Minecraft minecraft, GuiGraphics guiGraphics) {
        if (this.hovered != null) {
            this.renderElement(guiGraphics, minecraft, this.hovered, -65536, this.hoveredName, false);
        }
    }

    @Override
    public void renderCacheSize(Minecraft minecraft, GuiGraphics guiGraphics) {
        String sizeString = "Cache Size: " + this.cache.size();
        Font font = minecraft.font;
        int textWidth = font.width(sizeString);
        Objects.requireNonNull(font);
        int textHeight = 9;
        float scale = 0.75f;
        int x = (int)((float)minecraft.getWindow().getGuiScaledWidth() - (float)textWidth * scale - 1.0f);
        int y = (int)((float)minecraft.getWindow().getGuiScaledHeight() - (float)textHeight * scale - 1.0f);
        PoseStack poseStack = guiGraphics.pose();
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 900.0f);
        poseStack.scale(scale, scale, 0.0f);
        guiGraphics.drawString(font, sizeString, (int)((float)x / scale), (int)((float)y / scale), -1);
        poseStack.popPose();
    }

    private void renderElement(GuiGraphics guiGraphics, Minecraft minecraft, GuiEventListener element, int color, String label, boolean bottomLabel) {
        ScreenRectangle rect = this.getBounds(element);
        PoseStack poseStack = guiGraphics.pose();
        Font font = minecraft.font;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 900.0f);
        guiGraphics.renderOutline(rect.left(), rect.top(), rect.width(), rect.height(), color);
        int textWidth = font.width(label);
        int screenWidth = minecraft.getWindow().getGuiScaledWidth();
        int textX = rect.left() + 1;
        if ((float)textX + (float)textWidth * 0.75f > (float)screenWidth && (textX = (int)((float)screenWidth - (float)textWidth * 0.75f)) < 0) {
            textX = 0;
        }
        int textY = rect.top() + 1;
        if (bottomLabel) {
            if (rect.height() == 0 && rect.width() == 0) {
                int n = minecraft.getWindow().getGuiScaledHeight();
                Objects.requireNonNull(font);
                textY = n - (int)(9.0f * 0.75f) - 1;
            } else {
                int n = rect.top() - 1;
                int n2 = rect.height();
                Objects.requireNonNull(font);
                textY = n + Math.max(0, n2 - (int)(9.0f * 0.75f));
            }
        }
        poseStack.scale(0.75f, 0.75f, 0.0f);
        guiGraphics.drawString(font, label, (int)((float)textX / 0.75f), (int)((float)textY / 0.75f), color);
        poseStack.popPose();
    }

    private ScreenRectangle getBounds(GuiEventListener element) {
        if (element instanceof LayoutElement) {
            LayoutElement le = (LayoutElement)element;
            return new ScreenRectangle(le.getX(), le.getY(), le.getWidth(), le.getHeight());
        }
        return element.getRectangle();
    }

    private String getClassName(GuiEventListener element) {
        String namespace = Services.PLATFORM.isDevelopmentEnvironment() ? "named" : "intermediary";
        return Services.PLATFORM.unmapClassName(namespace, element.getClass().getName());
    }

    @Nullable
    private GuiEventListener findDeepestChild(ContainerEventHandler parent, double mouseX, double mouseY) {
        Optional child = parent.getChildAt(mouseX, mouseY);
        if (child.isPresent()) {
            GuiEventListener hoveredElement = (GuiEventListener)child.get();
            if (hoveredElement instanceof ContainerEventHandler) {
                ContainerEventHandler nestedParent = (ContainerEventHandler)hoveredElement;
                GuiEventListener deepChild = this.findDeepestChild(nestedParent, mouseX, mouseY);
                return deepChild != null ? deepChild : hoveredElement;
            }
            return hoveredElement;
        }
        return null;
    }
}

