/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.util;

import net.minecraft.network.chat.Component;

public class SettingsUtil {
    public static final double SCALE_AUTO_THRESHOLD_MAX = 0.49;
    public static final double SCALE = 1.0;
    public static final double SCALE_MIN = 0.0;
    public static final double SCALE_MAX = 8.0;
    public static final double SCALE_STEP = 0.05;
    public static final int X_HOT = 0;
    public static final int Y_HOT = 0;
    public static final int HOT_MIN = 0;
    public static final int HOT_MAX = 31;
    public static final boolean ENABLED = true;

    private SettingsUtil() {
    }

    public static boolean isAutoScale(double scale) {
        return scale <= 0.49;
    }

    public static Component getAutoText(double scale) {
        return SettingsUtil.isAutoScale(scale) ? Component.translatable((String)"options.guiScale.auto") : null;
    }

    public static double sanitizeScale(double scale) {
        double clampedScale = SettingsUtil.clamp(scale, 0.0, 8.0);
        double mappedScale = (double)Math.round(clampedScale / 0.05) * 0.05;
        if (SettingsUtil.isAutoScale(mappedScale)) {
            return 0.0;
        }
        return (double)Math.round(mappedScale * 100.0) / 100.0;
    }

    public static int sanitizeHotspot(int hotspot) {
        return SettingsUtil.clamp(hotspot, 0, 31);
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }
}

