package io.github.fishstiz.minecraftcursor.cursorhandler.ingame;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.mixin.access.CreativeInventoryScreenAccessor;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.class_1735;
import net.minecraft.class_1761;
import net.minecraft.class_481;
import net.minecraft.class_7706;

public class CreativeInventoryScreenCursorHandler extends HandledScreenCursorHandler<class_481.class_483, class_481> {
    // Derived from CreativeInventoryScreen#renderTabTooltipIfHovered
    public static final int TAB_WIDTH = 21;
    public static final int TAB_HEIGHT = 27;
    public static final int TAB_OFFSET_X = 3;
    public static final int TAB_OFFSET_Y = 3;

    @Override
    public CursorType getCursorType(class_481 creativeInventoryScreen, double mouseX, double mouseY) {
        CursorType handledScreenCursor = super.getCursorType(creativeInventoryScreen, mouseX, mouseY);
        if (handledScreenCursor != CursorType.DEFAULT) {
            return handledScreenCursor;
        }

        CreativeInventoryScreenAccessor accessor = (CreativeInventoryScreenAccessor) creativeInventoryScreen;
        CursorType cursorType = getCursorTypeTabs(accessor, mouseX, mouseY);
        cursorType = cursorType != CursorType.DEFAULT ? cursorType : getCursorTypeDelete(accessor);
        return cursorType;
    }

    private CursorType getCursorTypeTabs(CreativeInventoryScreenAccessor creativeInventoryScreen, double mouseX, double mouseY) {
        if (!MinecraftCursor.CONFIG.isCreativeTabsEnabled()) return CursorType.DEFAULT;

        boolean isHovered = false;
        for (class_1761 itemGroup : class_7706.method_47335()) {
            // noinspection ConstantConditions
            if (creativeInventoryScreen.invokeIsPointWithinBounds(
                    creativeInventoryScreen.invokeGetTabX(itemGroup) + TAB_OFFSET_X,
                    creativeInventoryScreen.invokeGetTabY(itemGroup) + TAB_OFFSET_Y,
                    TAB_WIDTH,
                    TAB_HEIGHT,
                    mouseX,
                    mouseY)
                    && itemGroup != CreativeInventoryScreenAccessor.getSelectedTab()) {
                isHovered = true;
                break;
            }
        }
        // noinspection ConstantConditions
        return isHovered ? CursorType.POINTER : CursorType.DEFAULT;
    }

    private CursorType getCursorTypeDelete(CreativeInventoryScreenAccessor creativeInventoryScreen) {
        class_1735 focusedSlot = creativeInventoryScreen.getFocusedSlot();
        if (CursorTypeUtil.canShift()
                && focusedSlot != null
                && focusedSlot == creativeInventoryScreen.getDeleteItemSlot()) {
            return CursorType.SHIFT;
        }
        return CursorType.DEFAULT;
    }
}
