package io.github.fishstiz.minecraftcursor.gui.widget;

import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_357;

public class SelectedCursorSliderWidget extends class_357 {
    private final class_2561 prefix;
    private final double min;
    private final double max;
    private final double step;
    private final String suffix;
    private final Consumer<Double> onApply;
    private final @Nullable Runnable onRelease;
    private double translatedValue;
    private SelectedCursorButtonWidget inactiveHelperButton;

    public SelectedCursorSliderWidget(
            class_2561 text,
            double defaultValue,
            double min,
            double max,
            double step,
            Consumer<Double> onApply,
            Runnable onRelease
    ) {
        this(text, defaultValue, min, max, step, "", onApply, onRelease);
    }

    public SelectedCursorSliderWidget(
            class_2561 text,
            double defaultValue,
            double min,
            double max,
            double step,
            String suffix,
            Consumer<Double> onApply
    ) {
        this(text, defaultValue, min, max, step, suffix, onApply, null);
    }

    public SelectedCursorSliderWidget(
            class_2561 text,
            double defaultValue,
            double min,
            double max,
            double step,
            String suffix,
            Consumer<Double> onApply,
            @Nullable Runnable onRelease
    ) {
        super(0, 0, 0, 0, text, defaultValue);

        this.prefix = text;
        this.min = min;
        this.max = max;
        this.step = step;
        this.suffix = suffix;
        this.onApply = onApply;
        this.onRelease = onRelease;

        this.field_22753 = translatedValueToValue(defaultValue);

        translateValue();
        method_25346();
    }

    private double translatedValueToValue(double translatedValue) {
        double clampedValue = Math.max(min, Math.min(translatedValue, max));
        return (clampedValue - min) / (max - min);
    }

    public void update(double translatedValue, boolean active) {
        setTranslatedValue(translatedValue);
        this.field_22763 = active;
    }

    public void setTranslatedValue(double translatedValue) {
        field_22753 = translatedValueToValue(translatedValue);

        method_25344();
        method_25346();
    }

    private void translateValue() {
        double scaledValue = min + (field_22753 * (max - min));
        translatedValue = Math.round(scaledValue / step) * step;
    }

    @Override
    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        SelectedCursorButtonWidget helperButton = getInactiveHelperButton();
        boolean isHelperButtonPresent = helperButton != null;

        if (isHelperButtonPresent) {
            helperButton.field_22763 = !field_22763;
        }

        if (isHelperButtonPresent && isMouseOverInactive(mouseX, mouseY)) {
            renderAroundHelperButton(context, mouseX, mouseY, delta, helperButton);
            helperButton.method_25394(context, mouseX, mouseY, delta);
        } else {
            super.method_48579(context, mouseX, mouseY, delta);
        }

        field_22762 = method_25405(mouseX, mouseY);
    }

    private void renderAroundHelperButton(
            class_332 context,
            int mouseX,
            int mouseY,
            float delta,
            SelectedCursorButtonWidget helperButton
    ) {
        int x = method_46426();
        int y = method_46427();
        int right = method_55442();
        int bottom = method_55443();
        int helperY = helperButton.method_46427();
        int helperBottom = helperButton.method_55443();

        renderSection(context, mouseX, mouseY, delta, x, y, right, helperY); // top
        renderSection(context, mouseX, mouseY, delta, x, helperBottom, right, bottom); // bottom
        renderSection(context, mouseX, mouseY, delta, x, helperY, helperButton.method_46426(), helperBottom); // left
        renderSection(context, mouseX, mouseY, delta, helperButton.method_55442(), helperY, right, helperBottom); // right
    }

    private void renderSection(class_332 context, int mouseX, int mouseY, float delta, int x1, int y1, int x2, int y2) {
        context.method_44379(x1, y1, x2, y2);
        super.method_48579(context, mouseX, mouseY, delta);
        context.method_44380();
    }

    @Override
    protected void method_25344() {
        double previousTranslatedValue = translatedValue;

        translateValue();

        if (method_25370() && previousTranslatedValue != translatedValue) {
            onApply.accept(translatedValue);
        }
    }

    @Override
    protected void method_25346() {
        String formattedValue = String.format(step % 1 == 0 ? "%.0f" : "%.2f", translatedValue);
        method_25355(class_2561.method_43473().method_10852(prefix).method_10852(class_2561.method_30163(": " + formattedValue + suffix)));
    }

    public double getTranslatedValue() {
        return translatedValue;
    }

    @Override
    public void method_25357(double mouseX, double mouseY) {
        super.method_25357(mouseX, mouseY);
        method_25365(false);

        if (this.onRelease != null) {
            this.onRelease.run();
        }
    }

    public @Nullable SelectedCursorButtonWidget getInactiveHelperButton() {
        if (inactiveHelperButton == null) return null;

        int marginRight = 2;
        int x = (method_46426() + method_25368()) - inactiveHelperButton.method_25368() - marginRight;
        int y = method_46427() + (method_25364() - inactiveHelperButton.method_25364()) / 2;

        inactiveHelperButton.method_48229(x, y);
        return inactiveHelperButton;
    }

    public void setInactiveHelperButton(SelectedCursorButtonWidget helperButton, int width, int height) {
        this.inactiveHelperButton = helperButton;
        this.inactiveHelperButton.method_55445(width, height);
    }

    public class_2561 getPrefix() {
        return this.prefix;
    }

    public boolean isMouseOverInactive(int mouseX, int mouseY) {
        return !field_22763
                && mouseX >= method_46426()
                && mouseY >= method_46427()
                && mouseX < method_55442()
                && mouseY < method_55443();
    }
}