package io.github.fishstiz.minecraftcursor.util;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;

public class CursorTypeUtil {
    private CursorTypeUtil() {
    }

    private static class Client {
        private static final class_310 MINECRAFT = class_310.method_1551();
    }

    public static boolean canShift() {
        long handle = Client.MINECRAFT.method_22683().method_4490();
        return CursorManager.INSTANCE.getCursor(CursorType.SHIFT).getId() != 0
                && (class_3675.method_15987(handle, GLFW.GLFW_KEY_LEFT_SHIFT)
                || class_3675.method_15987(handle, GLFW.GLFW_KEY_RIGHT_SHIFT));
    }

    public static boolean isGrabbing() {
        return CursorManager.INSTANCE.getCursor(CursorType.GRABBING).getId() != 0
                && CursorManager.INSTANCE.getCurrentCursor().getType() == CursorType.GRABBING
                && isLeftClickHeld();
    }

    public static boolean isLeftClickHeld() {
        return GLFW.glfwGetMouseButton(Client.MINECRAFT.method_22683().method_4490(), GLFW.GLFW_MOUSE_BUTTON_1) == GLFW.GLFW_PRESS;
    }
}
