/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.compat;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.compat.CursorTracker;
import io.github.fishstiz.minecraftcursor.compat.DefaultCursorTracker;
import io.github.fishstiz.minecraftcursor.compat.ExternalCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.Util;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class ExternalCursorTracker
implements CursorTracker {
    private static final List<Long> INTERNAL_IMAGES = Collections.synchronizedList(new ArrayList(2));
    private static boolean tracking = false;
    private final StackWalker walker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private final Map<Long, ExternalCursor> externalCursors = new HashMap<Long, ExternalCursor>();
    private final Map<Integer, CursorTimestamp> currentCursors = new HashMap<Integer, CursorTimestamp>();
    private boolean hasCustomCursor;

    private ExternalCursorTracker() {
    }

    private void updateCursorTimestamp(int caller, CursorType cursorType) {
        if (cursorType == null) {
            return;
        }
        CursorTimestamp cursorTimestamp = this.currentCursors.get(caller);
        if (cursorTimestamp == null) {
            this.currentCursors.put(caller, new CursorTimestamp(cursorType));
        } else {
            cursorTimestamp.update(cursorType);
        }
    }

    private boolean shouldReplaceCursor(CursorTimestamp current, CursorTimestamp other) {
        boolean isOtherCustom;
        if (current == null) {
            return true;
        }
        boolean isCurrentCustom = current.cursorType == ExternalCursor.CUSTOM;
        boolean bl = isOtherCustom = other.cursorType == ExternalCursor.CUSTOM;
        if (isOtherCustom != isCurrentCustom) {
            return isOtherCustom;
        }
        if (isCurrentCustom) {
            return other.timestamp > current.timestamp;
        }
        if (other.cursorType.isDefault() != current.cursorType.isDefault()) {
            return !other.cursorType.isDefault();
        }
        return other.timestamp > current.timestamp;
    }

    private CursorType getLatestCursorOrDefault() {
        CursorTimestamp latestCursorTimestamp = null;
        for (CursorTimestamp cursorTimestamp : this.currentCursors.values()) {
            if (!this.shouldReplaceCursor(latestCursorTimestamp, cursorTimestamp)) continue;
            latestCursorTimestamp = cursorTimestamp;
        }
        return latestCursorTimestamp != null ? latestCursorTimestamp.cursorType : CursorType.DEFAULT;
    }

    @Override
    @Nullable
    public ExternalCursor getTrackedCursor(long cursor) {
        return this.externalCursors.get(cursor);
    }

    @Override
    public void untrackCursor(long cursor) {
        this.externalCursors.remove(cursor);
    }

    @Override
    public void updateCursor(int caller, CursorType cursorType) {
        this.updateCursorTimestamp(caller, cursorType);
    }

    @Override
    public boolean isTracking(long cursor) {
        return this.externalCursors.containsKey(cursor);
    }

    @Override
    @NotNull
    public CursorType getCursorOrDefault() {
        return this.getLatestCursorOrDefault();
    }

    @Override
    public boolean isCustom() {
        return this.hasCustomCursor && this.getCursorOrDefault() == ExternalCursor.CUSTOM;
    }

    public static boolean isTracking() {
        return tracking;
    }

    public static CursorTracker get() {
        if (!ExternalCursorTracker.isTracking()) {
            return DefaultCursorTracker.getInstance();
        }
        return Holder.INSTANCE;
    }

    public static void trackCursor(long cursor, int caller, CursorType cursorType) {
        ExternalCursor externalCursor = Holder.INSTANCE.getTrackedCursor(cursor);
        if (externalCursor == null) {
            externalCursor = new ExternalCursor(caller, cursorType);
            Holder.INSTANCE.externalCursors.put(cursor, externalCursor);
        }
        if (cursorType == ExternalCursor.CUSTOM) {
            Holder.INSTANCE.hasCustomCursor = true;
        }
        externalCursor.update(cursorType);
    }

    public static void trackCursor(long cursor, int caller) {
        ExternalCursorTracker.trackCursor(cursor, caller, ExternalCursor.CUSTOM);
    }

    public static void trackInternalCursor(long image) {
        INTERNAL_IMAGES.add(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean consumeInternalCursor(long image) {
        List<Long> list = INTERNAL_IMAGES;
        synchronized (list) {
            return INTERNAL_IMAGES.remove(image);
        }
    }

    public static StackWalker getWalker() {
        return Holder.INSTANCE.walker;
    }

    public static String getCallerPackage(Stream<StackWalker.StackFrame> frames) {
        return frames.dropWhile(frame -> frame.getDeclaringClass() == GLFW.class).findFirst().map(frame -> frame.getDeclaringClass().getPackageName()).orElse("placeholder");
    }

    public static boolean isInternalPackage(String packageName) {
        return packageName.startsWith("io.github.fishstiz.minecraftcursor");
    }

    private static class CursorTimestamp {
        CursorType cursorType;
        long timestamp;

        public CursorTimestamp(CursorType cursorType) {
            this.cursorType = cursorType;
            this.timestamp = Util.getMillis();
        }

        public void update(CursorType cursorType) {
            if (this.cursorType != cursorType) {
                this.timestamp = Util.getMillis();
            }
            this.cursorType = cursorType;
        }
    }

    private static class Holder {
        private static final ExternalCursorTracker INSTANCE = new ExternalCursorTracker();

        private Holder() {
        }

        static {
            tracking = true;
            MinecraftCursor.LOGGER.info("[minecraft-cursor] Tracking cursors from other mods...");
        }
    }
}

