/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui;

import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.AnimationState;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;

public class CursorAnimationHelper {
    private final Map<String, AnimationState> cursorStates = new HashMap<String, AnimationState>();

    public void reset(AnimatedCursor cursor) {
        AnimationState cursorState = this.cursorStates.get(cursor.getTypeKey());
        if (cursorState != null) {
            cursorState.reset();
        }
    }

    public void drawSprite(GuiGraphics guiGraphics, Cursor cursor, int x, int y, int size) {
        if (cursor.isLoaded()) {
            int n;
            int cursorSize = cursor.getTextureWidth();
            if (cursor instanceof AnimatedCursor) {
                AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
                n = this.getCurrentSpriteIndex(animatedCursor);
            } else {
                n = 0;
            }
            float spriteIndex = n;
            guiGraphics.blit(RenderType::guiTextured, cursor.getLocation(), x, y, 0.0f, (float)cursorSize * spriteIndex, size, size, cursorSize, cursorSize, cursor.getTextureWidth(), cursor.getTextureHeight());
        }
    }

    private int getCurrentSpriteIndex(AnimatedCursor cursor) {
        AnimationState state = this.cursorStates.computeIfAbsent(cursor.getType().getKey(), t -> new AnimationState());
        if (!cursor.isAnimated() || !cursor.isEnabled()) {
            state.reset();
            return cursor.getFallbackFrame().cursor().getTextureIndex();
        }
        return cursor.nextFrame(state).cursor().getTextureIndex();
    }
}

