/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen.panel;

import io.github.fishstiz.minecraftcursor.CursorResourceLoader;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorController;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import io.github.fishstiz.minecraftcursor.gui.MouseEvent;
import io.github.fishstiz.minecraftcursor.gui.screen.panel.AbstractOptionsPanel;
import io.github.fishstiz.minecraftcursor.gui.widget.ButtonWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorPreviewWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.OptionsListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SliderWidget;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalOptionsPanel
extends AbstractOptionsPanel {
    private static final class_2561 TITLE = class_2561.method_43471((String)"minecraft-cursor.options.global.title");
    private static final class_7919 SCALE_TOOLTIP = GlobalOptionsPanel.createGlobalTooltip(SCALE_TEXT);
    private static final class_7919 XHOT_TOOLTIP = GlobalOptionsPanel.createGlobalTooltip(XHOT_TEXT);
    private static final class_7919 YHOT_TOOLTIP = GlobalOptionsPanel.createGlobalTooltip(YHOT_TEXT);
    private static final class_2561 ANIMATIONS_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.global.animation");
    private static final class_7919 ANIMATIONS_INFO = class_7919.method_47407((class_2561)class_2561.method_43471((String)"minecraft-cursor.options.global.animation.tooltip"));
    private static final class_2561 RESET_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.resource_pack.reset");
    private static final class_7919 RESET_INFO = class_7919.method_47407((class_2561)class_2561.method_43471((String)"minecraft-cursor.options.resource_pack.reset.tooltip"));
    private static final int PREVIEW_BUTTON_SIZE = 20;
    private static final int SCALE_OVERRIDE = -20;
    private final Runnable refreshCursors;
    @NotNull
    private Iterator<Cursor> cursors = GlobalOptionsPanel.cursorIterator();
    @NotNull
    private Cursor currentCursor = GlobalOptionsPanel.getDefaultCursor();
    private OptionsListWidget optionList;
    private GlobalPreviewWidget previewWidget;

    public GlobalOptionsPanel(Runnable refreshCursors) {
        super(TITLE);
        this.refreshCursors = refreshCursors;
    }

    @Override
    protected void initContents() {
        this.recycleCursors();
        int maxHotspot = SettingsUtil.getMaxHotspot(CursorManager.INSTANCE.getCursors());
        this.previewWidget = new GlobalPreviewWidget(this.currentCursor, this.getFont(), new ButtonWidget(class_5244.field_39003, this::cycleOnPreviewPress).withSize(20));
        this.optionList = new OptionsListWidget(this.getMinecraft(), this.getFont(), 20, this.getSpacing());
        this.optionList.addToggleableSlider(new SliderWidget(MinecraftCursor.CONFIG.getGlobal().getScale(), 0.0, 8.0, 0.05, this::onChangeScale, this.index(SCALE_TEXT), class_5244.field_39003, SettingsUtil::getAutoText, this::onSliderMouseEvent), MinecraftCursor.CONFIG.getGlobal().isScaleActive(), GlobalOptionsPanel.applyGlobalOnToggle(MinecraftCursor.CONFIG.getGlobal()::setScaleActive), SCALE_TOOLTIP);
        this.optionList.addToggleableSlider(new SliderWidget(MinecraftCursor.CONFIG.getGlobal().getXHot(), 0.0, maxHotspot, 1.0, this::onChangeXHot, this.index(XHOT_TEXT), HOTSPOT_SUFFIX, null, this::onSliderMouseEvent), MinecraftCursor.CONFIG.getGlobal().isXHotActive(), GlobalOptionsPanel.applyGlobalOnToggle(MinecraftCursor.CONFIG.getGlobal()::setXHotActive), XHOT_TOOLTIP);
        this.optionList.addToggleableSlider(new SliderWidget(MinecraftCursor.CONFIG.getGlobal().getYHot(), 0.0, maxHotspot, 1.0, this::onChangeYHot, this.index(YHOT_TEXT), HOTSPOT_SUFFIX, null, this::onSliderMouseEvent), MinecraftCursor.CONFIG.getGlobal().isYHotActive(), GlobalOptionsPanel.applyGlobalOnToggle(MinecraftCursor.CONFIG.getGlobal()::setYHotActive), YHOT_TOOLTIP);
        this.optionList.addToggle(this.isAnimatedAny(), this::toggleCursorAnimations, this.index(ANIMATIONS_TEXT), ANIMATIONS_INFO, this.hasAnimationAny());
        this.optionList.addWidget((class_339)new ButtonWidget(this.index(RESET_TEXT), this::resetCursorSettings).withTooltip(RESET_INFO));
        this.optionList.search(this.getSearch());
        this.addRenderableWidget(this.previewWidget);
        this.addRenderableWidget(this.optionList);
    }

    @Override
    protected void repositionContents(int x, int y) {
        if (this.previewWidget != null && this.optionList != null) {
            this.previewWidget.method_25358(this.getWidth());
            this.previewWidget.method_48229(x, y);
            this.optionList.method_55445(this.getWidth(), this.computeMaxHeight(y) - this.previewWidget.method_25364() - this.getSpacing());
            this.optionList.method_48229(x, this.previewWidget.method_55443() + this.getSpacing());
        }
    }

    private void onChangeScale(double scale) {
        MinecraftCursor.CONFIG.getGlobal().setScale(scale);
        if (MinecraftCursor.CONFIG.getGlobal().isScaleActive()) {
            this.currentCursor.setScale(scale);
        }
    }

    private void onChangeXHot(double xhot) {
        MinecraftCursor.CONFIG.getGlobal().setXHot(xhot);
        if (MinecraftCursor.CONFIG.getGlobal().isXHotActive()) {
            this.currentCursor.setXHot(xhot);
        }
    }

    private void onChangeYHot(double yhot) {
        MinecraftCursor.CONFIG.getGlobal().setYHot(yhot);
        if (MinecraftCursor.CONFIG.getGlobal().isYHotActive()) {
            this.currentCursor.setYHot(yhot);
        }
    }

    private void onSliderMouseEvent(SliderWidget target, MouseEvent mouseEvent, double scale) {
        if (mouseEvent.released()) {
            if (target.getPrefix().equals((Object)SCALE_TEXT) && MinecraftCursor.CONFIG.getGlobal().isScaleActive()) {
                CursorManager.INSTANCE.getCursors().forEach(cursor -> cursor.setScale(MinecraftCursor.CONFIG.getGlobal().getScale()));
            } else if (target.getPrefix().equals((Object)XHOT_TEXT) && MinecraftCursor.CONFIG.getGlobal().isXHotActive()) {
                CursorManager.INSTANCE.getCursors().forEach(cursor -> cursor.setXHot(MinecraftCursor.CONFIG.getGlobal().getXHot()));
            } else if (target.getPrefix().equals((Object)YHOT_TEXT) && MinecraftCursor.CONFIG.getGlobal().isYHotActive()) {
                CursorManager.INSTANCE.getCursors().forEach(cursor -> cursor.setYHot(MinecraftCursor.CONFIG.getGlobal().getYHot()));
            }
            GlobalOptionsPanel.removeScaleOverride();
        } else if (mouseEvent.clicked() && target.getPrefix().equals((Object)SCALE_TEXT) && CursorManager.INSTANCE.isEnabled(this.currentCursor)) {
            CursorController.getInstance().overrideCursor(this.currentCursor.getType(), -20);
        }
    }

    private void cycleOnPreviewPress(class_4185 target) {
        target.method_25365(false);
        this.cycleCurrentCursor();
    }

    private void cycleCurrentCursor() {
        if (!this.cursors.hasNext()) {
            this.cursors = GlobalOptionsPanel.cursorIterator();
        }
        Cursor cursor = this.currentCursor = this.cursors.hasNext() ? this.cursors.next() : GlobalOptionsPanel.getDefaultCursor();
        if (this.previewWidget != null) {
            this.previewWidget.setCursor(this.currentCursor);
        }
    }

    private void recycleCursors() {
        this.cursors = GlobalOptionsPanel.cursorIterator();
        this.cycleCurrentCursor();
    }

    private void toggleCursorAnimations(boolean animated) {
        for (Cursor cursor : CursorManager.INSTANCE.getCursors()) {
            if (!(cursor instanceof AnimatedCursor)) continue;
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            animatedCursor.setAnimated(animated);
            MinecraftCursor.CONFIG.getOrCreateSettings(animatedCursor).setAnimated(animated);
        }
    }

    private void resetCursorSettings() {
        CursorResourceLoader.restoreResourceSettings();
        this.refreshCursors.run();
        this.refreshWidgets();
        this.repositionElements();
    }

    @Override
    protected void removed() {
        GlobalOptionsPanel.removeScaleOverride();
    }

    @Override
    protected void searched(@NotNull String search, @Nullable class_2561 matched) {
        if (this.optionList != null) {
            this.optionList.search(search);
        }
    }

    public boolean hasAnimationAny() {
        for (Cursor cursor : CursorManager.INSTANCE.getCursors()) {
            if (!(cursor instanceof AnimatedCursor)) continue;
            return true;
        }
        return false;
    }

    public boolean isAnimatedAny() {
        for (Cursor cursor : CursorManager.INSTANCE.getCursors()) {
            AnimatedCursor animatedCursor;
            if (!(cursor instanceof AnimatedCursor) || !(animatedCursor = (AnimatedCursor)cursor).isAnimated()) continue;
            return true;
        }
        return false;
    }

    private static Consumer<Boolean> applyGlobalOnToggle(Consumer<Boolean> onToggle) {
        return value -> {
            onToggle.accept((Boolean)value);
            CursorManager.INSTANCE.getCursors().forEach(cursor -> cursor.apply(MinecraftCursor.CONFIG.getGlobal().apply(MinecraftCursor.CONFIG.getOrCreateSettings((Cursor)cursor))));
        };
    }

    private static class_7919 createGlobalTooltip(class_2561 message) {
        return class_7919.method_47407((class_2561)class_2561.method_43469((String)"minecraft-cursor.options.global.tooltip", (Object[])new Object[]{message}));
    }

    private static Iterator<Cursor> cursorIterator() {
        return CursorManager.INSTANCE.getCursors().stream().filter(Cursor::isEnabled).iterator();
    }

    @NotNull
    private static Cursor getDefaultCursor() {
        return Objects.requireNonNull(CursorManager.INSTANCE.getCursor(CursorType.DEFAULT));
    }

    public static void removeScaleOverride() {
        CursorController.getInstance().removeOverride(-20);
    }

    private static class GlobalPreviewWidget
    extends CursorPreviewWidget {
        private static final float CELL_DIVISOR = 32.0f;
        @NotNull
        private Cursor cursor;

        public GlobalPreviewWidget(@NotNull Cursor cursor, @NotNull class_327 font, @Nullable class_4185 button) {
            super(cursor, font, button);
            this.cursor = cursor;
        }

        @Override
        protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            this.renderBackground(guiGraphics);
            this.renderPreviewText(guiGraphics);
            this.renderTestButton(guiGraphics, mouseX, mouseY, partialTick);
            this.renderRuler(guiGraphics, mouseX, mouseY);
            this.renderBorder(guiGraphics);
        }

        @Override
        protected float getCellSize() {
            return (float)this.method_25368() / 32.0f;
        }

        public void setCursor(@NotNull Cursor cursor) {
            this.cursor = cursor;
        }

        @Override
        @NotNull
        public Cursor getCursor() {
            return this.cursor;
        }
    }
}

