package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.AnimationState;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1921;
import net.minecraft.class_332;

public class CursorAnimationHelper {
    private static final int CURSOR_SIZE = 32;
    private final Map<String, AnimationState> cursorStates = new HashMap<>();

    public void reset(AnimatedCursor cursor) {
        cursorStates.computeIfAbsent(cursor.getType().getKey(), t -> new AnimationState()).reset();
    }

    public void drawSprite(class_332 context, Cursor cursor, int x, int y, int size) {
        int frameIndex = 0;

        if (cursor instanceof AnimatedCursor animatedCursor) {
            frameIndex = getCurrentSpriteIndex(animatedCursor);
        }

        int vOffset = CURSOR_SIZE * frameIndex;

        context.method_25302(
                class_1921::method_62277,
                cursor.getSprite(),
                x, y,
                0, vOffset, // starting point
                size, size, // width/height to stretch/shrink
                CURSOR_SIZE, CURSOR_SIZE, // cropped width/height from actual image
                cursor.getTrueWidth(), cursor.getTrueHeight() // actual width/height
        );
    }

    private int getCurrentSpriteIndex(AnimatedCursor cursor) {
        AnimationState state = cursorStates.computeIfAbsent(cursor.getType().getKey(), t -> new AnimationState());

        if (!cursor.isAnimated()) {
            state.reset();
            return 0;
        }

        state.nextFrame(cursor);
        return cursor.getFrame(state.getCurrentFrame()).spriteIndex();
    }
}