/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursorhandler.ingame;

import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursorhandler.ingame.HandledScreenCursorHandler;
import io.github.fishstiz.minecraftcursor.mixin.access.RecipeAlternativesWidgetAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.RecipeBookResultsAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.RecipeBookScreenAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.RecipeBookWidgetAccessor;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.class_10260;
import net.minecraft.class_1729;
import net.minecraft.class_339;
import net.minecraft.class_361;
import net.minecraft.class_508;

public class RecipeBookScreenCursorHandler
extends HandledScreenCursorHandler<class_1729, class_10260<? extends class_1729>> {
    private RecipeAlternativesWidgetAccessor alternatesWidget;

    @Override
    public CursorType getCursorType(class_10260<? extends class_1729> recipeBookScreen, double mouseX, double mouseY) {
        boolean isResultHovered;
        CursorType cursorType = super.getCursorType(recipeBookScreen, mouseX, mouseY);
        if (!(cursorType == CursorType.DEFAULT || this.alternatesWidget != null && ((class_508)this.alternatesWidget).method_2616())) {
            return cursorType;
        }
        RecipeBookWidgetAccessor recipeBook = (RecipeBookWidgetAccessor)((RecipeBookScreenAccessor)recipeBookScreen).getRecipeBook();
        if (!recipeBook.invokeIsOpen()) {
            return CursorType.DEFAULT;
        }
        RecipeBookResultsAccessor recipesArea = (RecipeBookResultsAccessor)recipeBook.getRecipesArea();
        this.alternatesWidget = (RecipeAlternativesWidgetAccessor)recipesArea.getAlternatesWidget();
        if (((class_508)this.alternatesWidget).method_2616()) {
            return this.getAlternatesWidgetCursor(this.alternatesWidget);
        }
        boolean bl = isResultHovered = recipesArea.getHoveredResultButton() != null;
        if (isResultHovered && CursorTypeUtil.canShift()) {
            return CursorType.SHIFT;
        }
        if (this.isButtonHovered(recipeBook, recipesArea) || isResultHovered) {
            return CursorType.POINTER;
        }
        if (recipeBook.getSearchField().method_49606()) {
            return CursorType.TEXT;
        }
        return this.getTabCursor(recipeBook);
    }

    private CursorType getAlternatesWidgetCursor(RecipeAlternativesWidgetAccessor alternatesWidget) {
        if (alternatesWidget.getAlternativeButtons().stream().anyMatch(class_339::method_49606)) {
            return CursorTypeUtil.canShift() ? CursorType.SHIFT : CursorType.POINTER;
        }
        return CursorType.DEFAULT_FORCE;
    }

    private boolean isButtonHovered(RecipeBookWidgetAccessor recipeBook, RecipeBookResultsAccessor recipesArea) {
        class_361 prevPageButton = recipesArea.getPrevPageButton();
        class_361 nextPageButton = recipesArea.getNextPageButton();
        return prevPageButton.method_49606() && prevPageButton.field_22764 || nextPageButton.method_49606() && nextPageButton.field_22764 || recipeBook.getToggleCraftableButton().method_49606();
    }

    private CursorType getTabCursor(RecipeBookWidgetAccessor recipeBook) {
        boolean isUnselectedTabHovered = recipeBook.getTabButtons().stream().anyMatch(btn -> btn.method_49606() && btn != recipeBook.getCurrentTab());
        return isUnselectedTabHovered ? CursorType.POINTER : CursorType.DEFAULT;
    }
}

