/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.gui.screen.CursorOptionsScreen;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsHandler;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorButtonWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorHotspotWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorSliderWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorTestWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorToggleWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_9017;

public class CursorOptionsWidget
extends class_9017 {
    private static final int OPTIONS_HEIGHT = 24;
    private static final int GRID_PADDING = 4;
    private static final int BOX_WIDGET_TEXTURE_SIZE = 96;
    private static final int HELPER_BUTTON_SIZE = 16;
    private static final int HELPER_ICON_SIZE = 10;
    private static final class_2960 HELPER_ICON = class_2960.method_60656((String)"textures/gui/sprites/icon/unseen_notification.png");
    private static final String GLOBAL_TEXT_KEY = "minecraft-cursor.options.global.tooltip";
    private static final class_2561 ANIMATE_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.animate");
    private static final class_2561 RESET_ANIMATION_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.animate-reset");
    private static final String HOT_UNIT = "px";
    public static final class_2561 ENABLED_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.enabled");
    public static final class_2561 SCALE_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.scale");
    public static final class_2561 XHOT_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.xhot");
    public static final class_2561 YHOT_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.yhot");
    private final CursorOptionsScreen parent;
    private final CursorOptionsHandler handler;
    SelectedCursorToggleWidget enableButton;
    SelectedCursorSliderWidget scaleSlider;
    SelectedCursorSliderWidget xhotSlider;
    SelectedCursorSliderWidget yhotSlider;
    SelectedCursorToggleWidget animateButton;
    SelectedCursorButtonWidget resetAnimation;
    SelectedCursorHotspotWidget cursorHotspot;
    SelectedCursorTestWidget cursorTest;

    public CursorOptionsWidget(int x, int width, int height, int y, CursorOptionsScreen optionsScreen) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.parent = optionsScreen;
        this.handler = new CursorOptionsHandler(this);
        this.initWidgets();
    }

    private void initWidgets() {
        CursorConfig.Settings settings = this.handler.getSettings();
        this.enableButton = new SelectedCursorToggleWidget(ENABLED_TEXT, settings.isEnabled(), this.handler::handleEnable);
        this.scaleSlider = new SelectedCursorSliderWidget(SCALE_TEXT, settings.getScale(), 0.5, 3.0, 0.05, this.handler::handleChangeScale, CursorOptionsHandler::removeScaleOverride);
        this.bindHelperButton(this.scaleSlider);
        this.xhotSlider = this.createHotspotSlider(XHOT_TEXT, settings.getXHot(), this.handler::handleChangeXHot);
        this.yhotSlider = this.createHotspotSlider(YHOT_TEXT, settings.getYHot(), this.handler::handleChangeYHot);
        this.animateButton = new SelectedCursorToggleWidget(ANIMATE_TEXT, this.handler.isAnimated(), this.handler::handlePressAnimate);
        this.resetAnimation = new SelectedCursorButtonWidget(RESET_ANIMATION_TEXT, this.handler::handleResetAnimation);
        this.cursorHotspot = new SelectedCursorHotspotWidget(96, this);
        this.cursorHotspot.setChangeEventListener(this.handler::handleChangeHotspotWidget);
        this.cursorTest = new SelectedCursorTestWidget(96, this);
        this.refreshWidgets();
    }

    private SelectedCursorSliderWidget createHotspotSlider(class_2561 prefix, int value, DoubleConsumer onApply) {
        SelectedCursorSliderWidget slider = new SelectedCursorSliderWidget(prefix, (double)value, 0.0, 31.0, 1.0, HOT_UNIT, this.handler.handleChangeHotspots(onApply));
        this.bindHelperButton(slider);
        return slider;
    }

    private void bindHelperButton(SelectedCursorSliderWidget sliderWidget) {
        SelectedCursorButtonWidget helperButton = new SelectedCursorButtonWidget(HELPER_ICON, 10, 10, this.parent::toMoreOptions);
        helperButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43469((String)GLOBAL_TEXT_KEY, (Object[])new Object[]{sliderWidget.getPrefix()})));
        sliderWidget.setInactiveHelperButton(helperButton, 16, 16);
    }

    private void refreshWidgets() {
        CursorConfig.GlobalSettings global = MinecraftCursor.CONFIG.getGlobal();
        CursorConfig.Settings settings = this.handler.getSettings();
        this.enableButton.setValue(settings.isEnabled());
        this.scaleSlider.update(settings.getScale(), !global.isScaleActive());
        this.xhotSlider.update(settings.getXHot(), !global.isXHotActive());
        this.yhotSlider.update(settings.getYHot(), !global.isYHotActive());
        boolean isAnimated = this.handler.isAnimated();
        this.animateButton.field_22763 = this.handler.getCursorAsAnimatedCursor().isPresent();
        this.resetAnimation.field_22763 = isAnimated && this.enableButton.value;
        this.animateButton.setValue(isAnimated);
        this.cursorHotspot.setRulerRendered(true, true);
        this.cursorHotspot.field_22763 = !global.isXHotActive() || !global.isYHotActive();
        this.method_25396().forEach(widget -> widget.method_25365(false));
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        this.placeWidgets();
        this.enableButton.method_25394(context, mouseX, mouseY, delta);
        this.scaleSlider.method_48579(context, mouseX, mouseY, delta);
        this.xhotSlider.method_48579(context, mouseX, mouseY, delta);
        this.yhotSlider.method_48579(context, mouseX, mouseY, delta);
        if (this.handler.getCursorAsAnimatedCursor().isPresent()) {
            this.animateButton.method_25394(context, mouseX, mouseY, delta);
            this.resetAnimation.method_25394(context, mouseX, mouseY, delta);
        }
        this.cursorHotspot.method_48579(context, mouseX, mouseY, delta);
        this.cursorTest.method_48579(context, mouseX, mouseY, delta);
    }

    private void placeWidgets() {
        boolean isAnimatedCursor = this.handler.getCursorAsAnimatedCursor().isPresent();
        this.grid((class_339)this.enableButton, 0, 0);
        this.grid((class_339)this.scaleSlider, 1, 0);
        this.grid((class_339)this.xhotSlider, 0, 1);
        this.grid((class_339)this.yhotSlider, 1, 1);
        if (isAnimatedCursor) {
            this.grid((class_339)this.animateButton, 0, 2);
            this.grid((class_339)this.resetAnimation, 1, 2);
            this.grid(this.cursorHotspot, 0, 3, true);
            this.grid(this.cursorTest, 1, 3, true);
        } else {
            this.grid(this.cursorHotspot, 0, 2, true);
            this.grid(this.cursorTest, 1, 2, true);
        }
    }

    private void grid(class_339 widget, int gridX, int gridY) {
        this.grid(widget, gridX, gridY, false);
    }

    private void grid(class_339 widget, int gridX, int gridY, boolean absolute) {
        if (!absolute) {
            widget.method_25358(this.method_25368() / 2 - 4);
            widget.method_53533(20);
        }
        widget.method_46421(this.method_46426() + this.method_25368() / 2 * gridX);
        widget.method_46419(this.method_46427() + 24 * gridY);
    }

    public void save() {
        this.handler.updateSettings();
    }

    public void refresh() {
        this.refreshWidgets();
    }

    public CursorOptionsScreen parent() {
        return this.parent;
    }

    public List<? extends class_364> method_25396() {
        ArrayList<SelectedCursorTestWidget> children = new ArrayList<SelectedCursorTestWidget>(List.of(this.enableButton, this.scaleSlider, this.xhotSlider, this.yhotSlider, this.animateButton, this.resetAnimation, this.cursorHotspot, this.cursorTest));
        this.addHelperButton(this.scaleSlider, children);
        this.addHelperButton(this.xhotSlider, children);
        this.addHelperButton(this.yhotSlider, children);
        return children;
    }

    private void addHelperButton(SelectedCursorSliderWidget slider, List<class_364> children) {
        SelectedCursorButtonWidget helperButton;
        if (slider != null && (helperButton = slider.getInactiveHelperButton()) != null) {
            children.add((class_364)helperButton);
        }
    }

    protected int method_44395() {
        return 0;
    }

    protected double method_44393() {
        return 0.0;
    }

    protected void method_47399(class_6382 builder) {
    }
}

