/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorButtonWidget;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_357;
import org.jetbrains.annotations.Nullable;

public class SelectedCursorSliderWidget
extends class_357 {
    private final class_2561 prefix;
    private final double min;
    private final double max;
    private final double step;
    private final String suffix;
    private final Consumer<Double> onApply;
    @Nullable
    private final Runnable onRelease;
    private double translatedValue;
    private SelectedCursorButtonWidget inactiveHelperButton;

    public SelectedCursorSliderWidget(class_2561 text, double defaultValue, double min, double max, double step, Consumer<Double> onApply, Runnable onRelease) {
        this(text, defaultValue, min, max, step, "", onApply, onRelease);
    }

    public SelectedCursorSliderWidget(class_2561 text, double defaultValue, double min, double max, double step, String suffix, Consumer<Double> onApply) {
        this(text, defaultValue, min, max, step, suffix, onApply, null);
    }

    public SelectedCursorSliderWidget(class_2561 text, double defaultValue, double min, double max, double step, String suffix, Consumer<Double> onApply, @Nullable Runnable onRelease) {
        super(0, 0, 0, 0, text, defaultValue);
        this.prefix = text;
        this.min = min;
        this.max = max;
        this.step = step;
        this.suffix = suffix;
        this.onApply = onApply;
        this.onRelease = onRelease;
        this.field_22753 = this.translatedValueToValue(defaultValue);
        this.translateValue();
        this.method_25346();
    }

    private double translatedValueToValue(double translatedValue) {
        double clampedValue = Math.max(this.min, Math.min(translatedValue, this.max));
        return (clampedValue - this.min) / (this.max - this.min);
    }

    public void update(double translatedValue, boolean active) {
        this.setTranslatedValue(translatedValue);
        this.field_22763 = active;
    }

    public void setTranslatedValue(double translatedValue) {
        this.field_22753 = this.translatedValueToValue(translatedValue);
        this.method_25344();
        this.method_25346();
    }

    private void translateValue() {
        double scaledValue = this.min + this.field_22753 * (this.max - this.min);
        this.translatedValue = (double)Math.round(scaledValue / this.step) * this.step;
    }

    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        boolean isHelperButtonPresent;
        SelectedCursorButtonWidget helperButton = this.getInactiveHelperButton();
        boolean bl = isHelperButtonPresent = helperButton != null;
        if (isHelperButtonPresent) {
            boolean bl2 = helperButton.field_22763 = !this.field_22763;
        }
        if (isHelperButtonPresent && this.isMouseOverInactive(mouseX, mouseY)) {
            this.renderAroundHelperButton(context, mouseX, mouseY, delta, helperButton);
            helperButton.method_25394(context, mouseX, mouseY, delta);
        } else {
            super.method_48579(context, mouseX, mouseY, delta);
        }
        this.field_22762 = this.method_25405(mouseX, mouseY);
    }

    private void renderAroundHelperButton(class_332 context, int mouseX, int mouseY, float delta, SelectedCursorButtonWidget helperButton) {
        int x = this.method_46426();
        int y = this.method_46427();
        int right = this.method_55442();
        int bottom = this.method_55443();
        int helperY = helperButton.method_46427();
        int helperBottom = helperButton.method_55443();
        this.renderSection(context, mouseX, mouseY, delta, x, y, right, helperY);
        this.renderSection(context, mouseX, mouseY, delta, x, helperBottom, right, bottom);
        this.renderSection(context, mouseX, mouseY, delta, x, helperY, helperButton.method_46426(), helperBottom);
        this.renderSection(context, mouseX, mouseY, delta, helperButton.method_55442(), helperY, right, helperBottom);
    }

    private void renderSection(class_332 context, int mouseX, int mouseY, float delta, int x1, int y1, int x2, int y2) {
        context.method_44379(x1, y1, x2, y2);
        super.method_48579(context, mouseX, mouseY, delta);
        context.method_44380();
    }

    protected void method_25344() {
        double previousTranslatedValue = this.translatedValue;
        this.translateValue();
        if (this.method_25370() && previousTranslatedValue != this.translatedValue) {
            this.onApply.accept(this.translatedValue);
        }
    }

    protected void method_25346() {
        String formattedValue = String.format(this.step % 1.0 == 0.0 ? "%.0f" : "%.2f", this.translatedValue);
        this.method_25355((class_2561)class_2561.method_43473().method_10852(this.prefix).method_10852(class_2561.method_30163((String)(": " + formattedValue + this.suffix))));
    }

    public double getTranslatedValue() {
        return this.translatedValue;
    }

    public void method_25357(double mouseX, double mouseY) {
        super.method_25357(mouseX, mouseY);
        this.method_25365(false);
        if (this.onRelease != null) {
            this.onRelease.run();
        }
    }

    @Nullable
    public SelectedCursorButtonWidget getInactiveHelperButton() {
        if (this.inactiveHelperButton == null) {
            return null;
        }
        int marginRight = 2;
        int x = this.method_46426() + this.method_25368() - this.inactiveHelperButton.method_25368() - marginRight;
        int y = this.method_46427() + (this.method_25364() - this.inactiveHelperButton.method_25364()) / 2;
        this.inactiveHelperButton.method_48229(x, y);
        return this.inactiveHelperButton;
    }

    public void setInactiveHelperButton(SelectedCursorButtonWidget helperButton, int width, int height) {
        this.inactiveHelperButton = helperButton;
        this.inactiveHelperButton.method_55445(width, height);
    }

    public class_2561 getPrefix() {
        return this.prefix;
    }

    public boolean isMouseOverInactive(int mouseX, int mouseY) {
        return !this.field_22763 && mouseX >= this.method_46426() && mouseY >= this.method_46427() && mouseX < this.method_55442() && mouseY < this.method_55443();
    }
}

