/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.util;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;

public class BufferedImageUtil {
    private BufferedImageUtil() {
    }

    public static ByteBuffer getPixelsRGBA(BufferedImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] pixels = new int[width * height];
        image.getRGB(0, 0, width, height, pixels, 0, width);
        ByteBuffer buffer = BufferUtils.createByteBuffer((int)(width * height * 4));
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int pixel = pixels[y * width + x];
                buffer.put((byte)(pixel >> 16 & 0xFF));
                buffer.put((byte)(pixel >> 8 & 0xFF));
                buffer.put((byte)(pixel & 0xFF));
                buffer.put((byte)(pixel >> 24 & 0xFF));
            }
        }
        buffer.flip();
        return buffer;
    }

    public static BufferedImage scaleImage(BufferedImage image, double scale) {
        int width = (int)Math.round((double)image.getWidth() * scale);
        int height = (int)Math.round((double)image.getHeight() * scale);
        BufferedImage scaledImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = scaledImage.createGraphics();
        g2d.drawImage(image, 0, 0, width, height, null);
        g2d.dispose();
        return scaledImage;
    }

    public static String compressImageToBase64(BufferedImage image) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)image, "PNG", baos);
            byte[] imageData = baos.toByteArray();
            String string = Base64.getEncoder().encodeToString(imageData);
            return string;
        }
    }

    public static BufferedImage decompressBase64ToImage(String base64Image) throws IOException {
        byte[] imageData = Base64.getDecoder().decode(base64Image);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(imageData);){
            BufferedImage bufferedImage = ImageIO.read(bais);
            return bufferedImage;
        }
    }

    public static BufferedImage cropImage(BufferedImage src, Rectangle rect) {
        try {
            return src.getSubimage(rect.x, rect.y, rect.width, rect.height);
        }
        catch (RasterFormatException e) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Image size {}x{} invalid. Required: {}x{} at index {} (y={})", new Object[]{src.getWidth(), src.getHeight(), rect.width, rect.height, rect.y == 0 ? rect.y : rect.y / rect.width, rect.y});
            return src;
        }
    }
}

