package io.github.fishstiz.minecraftcursor.cursor.resolver;

import io.github.fishstiz.minecraftcursor.cursor.CursorManager;
import io.github.fishstiz.minecraftcursor.platform.Services;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5251;
import net.minecraft.class_8021;
import net.minecraft.class_8030;

final class ElementInspectorImpl implements ElementInspector {
    private static final float TEXT_SCALE = 0.75f;
    private final class_2561 screenLabel = class_2561.method_43470("S: ").method_54663(0xFF339BFF); // blue
    private final class_2561 cacheLabel = class_2561.method_43470("Cache: ").method_54663(0xFFFFFFFF); // white
    private final class_2561 deepestLabel = class_2561.method_43470("D: ").method_54663(0xFF00FF00); // green
    private final class_2561 processedLabel = class_2561.method_43470("P: ").method_54663(0xFFFF0000); // red
    private final class_2561 virtualModeLabel = class_2561.method_43470("Virtual Mode: ").method_27692(class_124.field_1065);
    private Set<Class<?>> cache = new ObjectOpenHashSet<>();
    private class_2561 cacheText = class_2561.method_43473();
    private class_364 processed;
    private String processedName;
    private boolean enabled = true;

    @Override
    public boolean isInspecting() {
        return this.enabled;
    }

    @Override
    public void destroy() {
        this.enabled = false;
        this.cache.clear();
        this.cache = null;
        this.cacheText = null;
        this.processed = null;
        this.processedName = null;
    }

    @Override
    public boolean setProcessed(class_364 processed, boolean cached) {
        this.processed = processed;
        this.processedName = getClassName(processed);
        if (cached) {
            this.cache.add(processed.getClass());
            this.cacheText = cacheLabel.method_27661().method_27693(String.valueOf(cache.size()));
        }
        return true;
    }

    @Override
    public void render(class_310 minecraft, @NotNull class_437 screen, class_332 guiGraphics, double mouseX, double mouseY) {
        if (this.enabled) {
            class_8030 screenRectangle = getBounds(screen);
            renderScreenName(minecraft, screen, screenRectangle, guiGraphics);
            renderCacheSize(minecraft, screenRectangle, guiGraphics);
            renderProcessed(minecraft, renderDeepest(minecraft, screen, guiGraphics, mouseX, mouseY), guiGraphics);
            renderVirtualInfo(minecraft, screenRectangle, guiGraphics);
        }
    }

    private class_8030 renderDeepest(class_310 minecraft, class_437 screen, class_332 guiGraphics, double mouseX, double mouseY) {
        class_364 child = ElementWalker.findDeepest(screen, mouseX, mouseY);
        class_364 inspect = child != null ? child : screen;
        class_8030 bounds = getBounds(inspect);
        class_2561 label = deepestLabel.method_27661().method_27693(getClassName(inspect));
        renderInfo(minecraft, guiGraphics, bounds, label, Position.TOP_LEFT, true);
        return bounds;
    }

    private void renderProcessed(class_310 minecraft, class_8030 container, class_332 guiGraphics) {
        if (processed != null) {
            class_2561 label = processedLabel.method_27661().method_27693(processedName);
            class_8030 bounds = getBounds(processed);
            int index = bounds.method_49618() != container.method_49618() ? 0 : 1;
            this.renderInfo(minecraft, guiGraphics, bounds, label, Position.TOP_LEFT, index, true);
        }
    }

    private void renderScreenName(class_310 minecraft, class_437 screen, class_8030 bounds, class_332 guiGraphics) {
        class_2561 label = screenLabel.method_27661().method_27693(getClassName(screen));
        this.renderInfo(minecraft, guiGraphics, bounds, label, Position.BOTTOM_RIGHT, false);
    }

    private void renderCacheSize(class_310 minecraft, class_8030 screenBounds, class_332 guiGraphics) {
        this.renderInfo(minecraft, guiGraphics, screenBounds, cacheText, Position.BOTTOM_RIGHT, -1, false);
    }

    private void renderVirtualInfo(class_310 minecraft, class_8030 screenBounds, class_332 guiGraphics) {
        class_2561 virtualMode = virtualModeLabel.method_27661().method_10852(CursorManager.INSTANCE.isVirtual() ? class_5244.field_24332 : class_5244.field_24333);
        renderInfo(minecraft, guiGraphics, screenBounds, virtualMode, Position.TOP_RIGHT, false);
    }

    private void renderInfo(class_310 minecraft, class_332 guiGraphics, class_8030 bounds, class_2561 label, Position pos, boolean outline) {
        this.renderInfo(minecraft, guiGraphics, bounds, label, pos, 0, outline);
    }

    private void renderInfo(class_310 minecraft, class_332 guiGraphics, class_8030 bounds, class_2561 label, Position pos, int index, boolean outline) {
        class_5251 textColor = label.method_10866().method_10973();
        int color = 0xFF000000 | (textColor != null ? textColor.method_27716() : 0xFFFFFFFF);

        int textX = pos.getX(minecraft, bounds, label, TEXT_SCALE);
        int textY = pos.getY(minecraft, bounds, index, TEXT_SCALE);

        Matrix3x2fStack matrix3x2fStack = guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_71048();
        if (outline) guiGraphics.method_49601(bounds.method_49620(), bounds.method_49618(), bounds.comp_1196(), bounds.comp_1197(), color);
        matrix3x2fStack.translate(TEXT_SCALE, TEXT_SCALE);
        matrix3x2fStack.scale(TEXT_SCALE, TEXT_SCALE);
        guiGraphics.method_27535(minecraft.field_1772, label, textX, textY, color);
        matrix3x2fStack.popMatrix();
    }

    private class_8030 getBounds(@Nullable class_364 element) {
        if (element instanceof class_8021 layoutElement) {
            return layoutElement.method_48202();
        }
        return element != null ? element.method_48202() : class_8030.method_48248();
    }

    private String getClassName(class_364 element) {
        String namespace = Services.PLATFORM.isDevelopmentEnvironment() ? "named" : "intermediary";
        return Services.PLATFORM.unmapClassName(namespace, element.getClass().getName());
    }

    public enum Position {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

        private static final int PADDING = 2;

        public int getX(class_310 minecraft, class_8030 bounds, class_2561 text, float scale) {
            int screenWidth = minecraft.method_22683().method_4486();
            int textWidth = minecraft.field_1772.method_27525(text);

            int x = switch (this) {
                case TOP_LEFT, BOTTOM_LEFT -> (int) ((bounds.method_49620() + PADDING) / scale);
                case TOP_RIGHT, BOTTOM_RIGHT -> {
                    int unscaledX = bounds.method_49620() + bounds.comp_1196() - (int) (textWidth * scale) - PADDING;
                    yield (int) (unscaledX / scale);
                }
            };

            if ((x + textWidth) * scale > screenWidth) {
                x = (int) ((screenWidth - textWidth * scale - PADDING) / scale);
                if (x < 0) x = 0;
            }

            return x;
        }

        public int getY(class_310 minecraft, class_8030 bounds, int index, float scale) {
            int screenHeight = minecraft.method_22683().method_4502();
            int textHeight = minecraft.field_1772.field_2000;
            int offsetY = index * textHeight;

            return switch (this) {
                case TOP_LEFT, TOP_RIGHT -> (int) ((bounds.method_49618() + PADDING + offsetY) / scale);
                case BOTTOM_LEFT, BOTTOM_RIGHT -> {
                    if (bounds.comp_1197() == 0 && bounds.comp_1196() == 0) {
                        yield (int) ((screenHeight - textHeight - PADDING - offsetY) / scale);
                    }
                    yield (int) ((bounds.method_49618() - PADDING + Math.max(0, bounds.comp_1197() - textHeight) + offsetY) / scale);
                }
            };
        }
    }
}
