package io.github.fishstiz.minecraftcursor.cursor.resolver;

import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4069;

public final class ElementWalker {
    private ElementWalker() {
    }

    public static <T> T walk(
            class_4069 parent,
            double mouseX,
            double mouseY,
            Processor<T> processor,
            Predicate<T> shouldReturn,
            T defaultValue
    ) {
        if (hovered(parent, mouseX, mouseY)) {
            for (class_364 child : parent.method_25396()) {
                if (child instanceof class_4069 nestedParent) {
                    T result = walk(nestedParent, mouseX, mouseY, processor, shouldReturn, defaultValue);
                    if (shouldReturn.test(result)) {
                        return result;
                    }
                }
                if (hovered(child, mouseX, mouseY)) {
                    return processor.processNode(child, mouseX, mouseY);
                }
            }
        }
        return defaultValue;
    }

    public static @Nullable class_364 findDeepest(class_4069 parent, double mouseX, double mouseY) {
        return ElementWalker.walk(parent, mouseX, mouseY, (child, x, y) -> child, Objects::nonNull, null);
    }

    public static @Nullable class_364 findFirst(class_4069 parent, double mouseX, double mouseY) {
        if (hovered(parent, mouseX, mouseY)) {
            for (class_364 child : parent.method_25396()) {
                if (hovered(child, mouseX, mouseY)) {
                    return child;
                }
            }
        }
        return null;
    }

    /**
     * Include inactive widgets.
     *
     * <p>
     * Default implementation of {@link class_339#method_25405(double, double)}
     * returns false if {@link class_339#field_22763} is {@code false}.
     */
    private static boolean hovered(class_364 guiEventListener, double mouseX, double mouseY) {
        if (guiEventListener instanceof class_339 widget) {
            return widget.field_22764 && widget.method_49606() && widget.method_25405(mouseX, mouseY);
        }
        return guiEventListener.method_25405(mouseX, mouseY);
    }

    @FunctionalInterface
    public interface Processor<T> {
        T processNode(class_364 node, double mouseX, double mouseY);
    }
}
