/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.api.CursorTypeRegistrar;
import io.github.fishstiz.minecraftcursor.config.AnimatedCursorConfig;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.AnimationState;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public final class CursorManager
implements CursorTypeRegistrar {
    public static final CursorManager INSTANCE = new CursorManager();
    private final LinkedHashMap<String, Cursor> cursors = new LinkedHashMap();
    private final TreeMap<Integer, String> overrides = new TreeMap();
    private final AnimationState animationState = new AnimationState();
    private Cursor currentCursor = new Cursor(CursorType.of((String)""), null);

    private CursorManager() {
    }

    public void register(CursorType ... cursorTypes) {
        for (CursorType cursorType : cursorTypes) {
            this.register(cursorType);
        }
    }

    public CursorType register(String key) {
        return this.register(CursorType.of((String)key));
    }

    private CursorType register(CursorType cursorType) {
        String key = cursorType.getKey();
        if (key.isEmpty()) {
            throw new NullPointerException("Cursor type key cannot be empty.");
        }
        if (this.cursors.containsKey(key)) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Cursor type '{}' is already registered.", (Object)key);
            return cursorType;
        }
        this.cursors.put(key, new Cursor(cursorType, this::handleCursorLoad));
        return cursorType;
    }

    public void loadCursorImage(CursorType type, ResourceLocation sprite, BufferedImage image, CursorConfig.Settings settings, @Nullable AnimatedCursorConfig animation) throws IOException {
        boolean animated = animation != null;
        Cursor cursor = this.getCursor(type);
        CursorConfig.Settings updatedSettings = this.getUpdatedSettings(settings);
        if (animated != cursor instanceof AnimatedCursor) {
            cursor.destroy();
            cursor = this.createAppropiateCursor(type, animated);
            this.cursors.put(type.getKey(), cursor);
        }
        if (cursor instanceof AnimatedCursor) {
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            animatedCursor.loadImage(sprite, image, updatedSettings, animation);
        } else {
            cursor.loadImage(sprite, image, updatedSettings);
        }
    }

    private CursorConfig.Settings getUpdatedSettings(CursorConfig.Settings settings) {
        CursorConfig.GlobalSettings global = MinecraftCursor.CONFIG.getGlobal();
        CursorConfig.Settings updatedSettings = new CursorConfig.Settings();
        updatedSettings.update(global.isScaleActive() ? global.getScale() : settings.getScale(), global.isXHotActive() ? global.getXHot() : settings.getXHot(), global.isYHotActive() ? global.getYHot() : settings.getYHot(), settings.isEnabled());
        if (settings.isAnimated() != null) {
            updatedSettings.setAnimated(settings.isAnimated());
        }
        return updatedSettings;
    }

    private Cursor createAppropiateCursor(CursorType type, boolean animated) {
        return animated ? new AnimatedCursor(type, this::handleCursorLoad) : new Cursor(type, this::handleCursorLoad);
    }

    private void handleCursorLoad(Cursor cursor) {
        if (this.getCurrentCursor().getId() == cursor.getId()) {
            this.reloadCursor();
        }
    }

    void setCurrentCursor(CursorType type) {
        Cursor cursor;
        Cursor override = this.getOverride().orElse(null);
        Cursor cursor2 = cursor = override != null ? override : this.getCursor(type.getKey());
        if (cursor instanceof AnimatedCursor) {
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            if (cursor.getId() != 0L) {
                this.handleCursorAnimation(animatedCursor);
                return;
            }
        }
        if (type != CursorType.DEFAULT && cursor.getId() == 0L || !cursor.isEnabled()) {
            cursor = this.getCursor(CursorType.DEFAULT);
        }
        this.updateCursor(cursor);
    }

    private void handleCursorAnimation(AnimatedCursor cursor) {
        if (cursor == null) {
            this.updateCursor(this.getCursor(CursorType.DEFAULT));
            return;
        }
        if (!this.getCurrentCursor().getType().getKey().equals(cursor.getType().getKey())) {
            this.animationState.reset();
        } else {
            this.animationState.nextFrame(cursor);
        }
        Cursor currentFrameCursor = cursor.getFrame(this.animationState.getCurrentFrame()).cursor();
        this.updateCursor(currentFrameCursor.getId() != 0L ? currentFrameCursor : cursor);
    }

    private void updateCursor(Cursor cursor) {
        if (this.currentCursor != null && cursor.getId() == this.currentCursor.getId()) {
            return;
        }
        this.currentCursor = cursor;
        GLFW.glfwSetCursor((long)Client.MINECRAFT.getWindow().getWindow(), (long)this.currentCursor.getId());
    }

    public void reloadCursor() {
        GLFW.glfwSetCursor((long)Client.MINECRAFT.getWindow().getWindow(), (long)this.getCurrentCursor().getId());
    }

    public void overrideCurrentCursor(CursorType type, int index) {
        if (this.getCursor(type).isEnabled()) {
            this.overrides.put(index, type.getKey());
        } else {
            this.overrides.remove(index);
        }
    }

    public void removeOverride(int index) {
        this.overrides.remove(index);
    }

    public Optional<Cursor> getOverride() {
        while (!this.overrides.isEmpty()) {
            Map.Entry<Integer, String> lastEntry = this.overrides.lastEntry();
            Cursor cursor = this.getCursor(lastEntry.getValue());
            if (cursor.getId() == 0L) {
                this.overrides.remove(lastEntry.getKey());
                continue;
            }
            return Optional.of(cursor);
        }
        return Optional.empty();
    }

    @NotNull
    public Cursor getCurrentCursor() {
        Cursor cursor;
        Cursor override = this.getOverride().orElse(null);
        Cursor cursor2 = cursor = override != null ? override : this.currentCursor;
        if (cursor instanceof AnimatedCursor) {
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            return animatedCursor.getFrame(this.animationState.getCurrentFrame()).cursor();
        }
        return cursor;
    }

    @NotNull
    public Cursor getCursor(String key) {
        return this.cursors.computeIfAbsent(key, k -> new Cursor(CursorType.of((String)k), this::handleCursorLoad));
    }

    @NotNull
    public Cursor getCursor(CursorType type) {
        return this.cursors.computeIfAbsent(type.getKey(), k -> new Cursor(type, this::handleCursorLoad));
    }

    public List<CursorType> getCursorTypes() {
        return this.cursors.keySet().stream().filter(type -> !type.isEmpty()).map(CursorType::of).toList();
    }

    public List<Cursor> getLoadedCursors() {
        ArrayList<Cursor> activeCursors = new ArrayList<Cursor>();
        for (Cursor cursor : this.cursors.values()) {
            if (!cursor.isLoaded()) continue;
            activeCursors.add(cursor);
        }
        return activeCursors;
    }

    public boolean isAdaptive() {
        return this.cursors.values().stream().anyMatch(cursor -> cursor.isEnabled() && CursorType.DEFAULT != cursor.getType());
    }

    public void setIsAdaptive(boolean isAdaptive) {
        this.cursors.values().forEach(cursor -> {
            if (cursor.getType() != CursorType.DEFAULT) {
                cursor.enable(isAdaptive);
            }
        });
    }

    public boolean hasAnimations() {
        for (Cursor cursor : this.cursors.values()) {
            if (!(cursor instanceof AnimatedCursor)) continue;
            return true;
        }
        return false;
    }

    public boolean isAnimated() {
        for (Cursor cursor : this.cursors.values()) {
            AnimatedCursor animatedCursor;
            if (!(cursor instanceof AnimatedCursor) || !(animatedCursor = (AnimatedCursor)cursor).isAnimated()) continue;
            return true;
        }
        return false;
    }

    public void setIsAnimated(boolean isAnimated) {
        this.cursors.values().forEach(cursor -> {
            if (cursor instanceof AnimatedCursor) {
                AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
                animatedCursor.setAnimated(isAnimated);
            }
        });
    }

    private static class Client {
        private static final Minecraft MINECRAFT = Minecraft.getInstance();

        private Client() {
        }
    }
}

