/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.CursorTypeResolver;
import io.github.fishstiz.minecraftcursor.api.CursorController;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.api.CursorTypeRegistrar;
import io.github.fishstiz.minecraftcursor.api.ElementRegistrar;
import io.github.fishstiz.minecraftcursor.compat.ExternalCursorTracker;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.config.CursorConfigLoader;
import io.github.fishstiz.minecraftcursor.impl.CursorControllerImpl;
import io.github.fishstiz.minecraftcursor.impl.MinecraftCursorInitializerImpl;
import io.github.fishstiz.minecraftcursor.platform.Services;
import io.github.fishstiz.minecraftcursor.provider.CursorControllerProvider;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import java.io.File;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinecraftCursor {
    public static final String MOD_ID = "minecraft-cursor";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"minecraft-cursor");
    public static final CursorConfig CONFIG = CursorConfigLoader.fromFile(new File(Services.PLATFORM.getConfigDir(), "minecraft-cursor.json"));
    private static MinecraftCursor instance;
    private final AtomicReference<CursorType> singleCycleCursor = new AtomicReference();
    private Screen visibleNonCurrentScreen;

    private MinecraftCursor() {
    }

    public static void init() {
        instance = new MinecraftCursor();
        new MinecraftCursorInitializerImpl().init(CursorManager.INSTANCE, CursorTypeResolver.INSTANCE);
        Services.PLATFORM.getEntrypoints().forEach(entrypoint -> {
            try {
                entrypoint.init((CursorTypeRegistrar)CursorManager.INSTANCE, (ElementRegistrar)CursorTypeResolver.INSTANCE);
            }
            catch (Exception | LinkageError e) {
                LOGGER.error("[minecraft-cursor] Skipping invalid implementation of MinecraftCursorInitializer");
            }
        });
        CursorControllerProvider.init((CursorController)CursorControllerImpl.INSTANCE);
    }

    public void beforeScreenInit(Screen screen) {
        CursorTypeResolver.INSTANCE.lastFailedElement = "";
        if (Client.MINECRAFT.screen == null) {
            CursorManager.INSTANCE.setCurrentCursor(CursorType.DEFAULT);
            this.visibleNonCurrentScreen = screen;
            return;
        }
        this.visibleNonCurrentScreen = null;
    }

    public void afterRenderScreen(int mouseX, int mouseY) {
        if (ExternalCursorTracker.get().isCustom()) {
            return;
        }
        if (Client.MINECRAFT.screen != null) {
            CursorManager.INSTANCE.setCurrentCursor(this.getCursorType(Client.MINECRAFT.screen, mouseX, mouseY));
        }
    }

    public void tick() {
        if (ExternalCursorTracker.get().isCustom()) {
            return;
        }
        if (Client.MINECRAFT.screen == null && this.visibleNonCurrentScreen != null && !Client.MINECRAFT.mouseHandler.isMouseGrabbed()) {
            double scale = Client.MINECRAFT.getWindow().getGuiScale();
            double mouseX = Client.MINECRAFT.mouseHandler.xpos() / scale;
            double mouseY = Client.MINECRAFT.mouseHandler.ypos() / scale;
            CursorManager.INSTANCE.setCurrentCursor(this.getCursorType(this.visibleNonCurrentScreen, mouseX, mouseY));
        } else if (Client.MINECRAFT.screen == null && this.visibleNonCurrentScreen == null) {
            CursorManager.INSTANCE.setCurrentCursor(ExternalCursorTracker.get().getCursorOrDefault());
        }
    }

    private CursorType getCursorType(Screen currentScreen, double mouseX, double mouseY) {
        Optional hoveredElement;
        if (!CursorManager.INSTANCE.isAdaptive()) {
            return CursorType.DEFAULT;
        }
        if (CursorTypeUtil.isGrabbing()) {
            return CursorType.GRABBING;
        }
        if (this.singleCycleCursor.get() != null) {
            CursorType cursorType = this.singleCycleCursor.get();
            this.singleCycleCursor.set(null);
            return cursorType;
        }
        CursorType externalCursor = ExternalCursorTracker.get().getCursorOrDefault();
        if (externalCursor != CursorType.DEFAULT) {
            return externalCursor;
        }
        CursorType cursorType = CursorTypeResolver.INSTANCE.resolve(currentScreen, mouseX, mouseY);
        if (cursorType == CursorType.DEFAULT && (hoveredElement = currentScreen.getChildAt(mouseX, mouseY)).isPresent()) {
            cursorType = CursorTypeResolver.INSTANCE.resolve((GuiEventListener)hoveredElement.get(), mouseX, mouseY);
        }
        return cursorType;
    }

    public static MinecraftCursor getInstance() {
        if (instance == null) {
            throw new IllegalStateException("MinecraftCursor not yet initialized.");
        }
        return instance;
    }

    public void setSingleCycleCursor(CursorType cursorType) {
        this.singleCycleCursor.set(cursorType);
    }

    private static class Client {
        private static final Minecraft MINECRAFT = Minecraft.getInstance();

        private Client() {
        }
    }
}

