/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.config.AnimatedCursorConfig;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class CursorConfigLoader {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private CursorConfigLoader() {
    }

    public static AnimatedCursorConfig getAnimationConfig(InputStream stream) throws IOException {
        return (AnimatedCursorConfig)MAPPER.readValue(stream, AnimatedCursorConfig.class);
    }

    public static CursorConfig fromStream(InputStream stream) throws IOException {
        return (CursorConfig)MAPPER.readValue(stream, CursorConfig.class);
    }

    public static CursorConfig fromFile(File file) {
        if (!file.getPath().endsWith(".json")) {
            throw new IllegalArgumentException("Unsupported file type.");
        }
        CursorConfig config = new CursorConfig();
        try {
            config = (CursorConfig)MAPPER.readValue(file, CursorConfig.class);
        }
        catch (FileNotFoundException e) {
            MinecraftCursor.LOGGER.info("[minecraft-cursor] Creating cursor config file at '{}'...", (Object)file.getPath());
            CursorConfigLoader.saveConfig(file, config);
        }
        catch (IOException e) {
            MinecraftCursor.LOGGER.warn("[minecraft-cursor] Failed to load cursor config at '{}'", (Object)file.getPath());
        }
        config.file = file;
        return config;
    }

    public static void saveConfig(File file, CursorConfig config) {
        try {
            MAPPER.writerWithDefaultPrettyPrinter().writeValue(file, (Object)config);
        }
        catch (IOException e) {
            MinecraftCursor.LOGGER.error("[minecraft-cursor] Failed to save config file at '{}'", (Object)file.getPath());
        }
    }
}

