/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursor;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;

public enum AnimationMode {
    LOOP,
    LOOP_REVERSE,
    FORWARDS,
    REVERSE,
    OSCILLATE,
    RANDOM,
    RANDOM_CYCLE;


    @JsonValue
    public String toLowerCase() {
        return this.name().toLowerCase();
    }

    @JsonCreator
    public static AnimationMode getOrDefault(String name) {
        try {
            return AnimationMode.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            MinecraftCursor.LOGGER.warn("[minecraft-cursor] Animation mode: '{}' does not exist. Using default 'loop'.", (Object)name);
            return LOOP;
        }
    }
}

