/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursorhandler.ingame;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursorhandler.ingame.HandledScreenCursorHandler;
import io.github.fishstiz.minecraftcursor.mixin.access.HandledScreenAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.inventory.EnchantmentMenu;

public class EnchantmentScreenCursorHandler
extends HandledScreenCursorHandler<EnchantmentMenu, EnchantmentScreen> {
    public static final int ENCHANTMENT_BTN_WIDTH = 108;
    public static final int ENCHANTMENT_BTN_HEIGHT = 19;
    public static final int ENCHANTMENT_BTN_OFFSET_X = 60;
    public static final int ENCHANTMENT_BTN_OFFSET_Y = 14;

    @Override
    public CursorType getCursorType(EnchantmentScreen enchantmentScreen, double mouseX, double mouseY) {
        CursorType cursorType = super.getCursorType(enchantmentScreen, mouseX, mouseY);
        if (cursorType != CursorType.DEFAULT) {
            return cursorType;
        }
        if (!MinecraftCursor.CONFIG.isEnchantmentsEnabled()) {
            return CursorType.DEFAULT;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return CursorType.DEFAULT;
        }
        HandledScreenAccessor accessor = (HandledScreenAccessor)enchantmentScreen;
        EnchantmentMenu handler = (EnchantmentMenu)accessor.getHandler();
        for (int i = 0; i < handler.costs.length; ++i) {
            boolean isButtonEnabled;
            int enchantmentPower = handler.costs[i];
            boolean bl = isButtonEnabled = enchantmentPower != 0 && (handler.getGoldCount() >= i + 1 && player.experienceLevel >= enchantmentPower || player.getAbilities().instabuild);
            if (!isButtonEnabled) continue;
            int containerX = (enchantmentScreen.width - accessor.getBackgroundWidth()) / 2;
            int containerY = (enchantmentScreen.height - accessor.getBackgroundHeight()) / 2;
            int buttonX = containerX + 60;
            int buttonY = containerY + 14 + 19 * i;
            int relativeX = (int)mouseX - buttonX;
            int relativeY = (int)mouseY - buttonY;
            if (relativeX < 0 || relativeY < 0 || relativeX >= 108 || relativeY >= 19) continue;
            return CursorType.POINTER;
        }
        return CursorType.DEFAULT;
    }
}

