/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.AnimationState;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;

public class CursorAnimationHelper {
    private static final int CURSOR_SIZE = 32;
    private final Map<String, AnimationState> cursorStates = new HashMap<String, AnimationState>();

    public void reset(AnimatedCursor cursor) {
        this.cursorStates.computeIfAbsent(cursor.getType().getKey(), t -> new AnimationState()).reset();
    }

    public void drawSprite(GuiGraphics context, Cursor cursor, int x, int y, int size) {
        int frameIndex = 0;
        if (cursor instanceof AnimatedCursor) {
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            frameIndex = this.getCurrentSpriteIndex(animatedCursor);
        }
        int vOffset = 32 * frameIndex;
        context.blit(RenderType::guiTextured, cursor.getSprite(), x, y, 0.0f, (float)vOffset, size, size, 32, 32, cursor.getTrueWidth(), cursor.getTrueHeight());
    }

    private int getCurrentSpriteIndex(AnimatedCursor cursor) {
        AnimationState state = this.cursorStates.computeIfAbsent(cursor.getType().getKey(), t -> new AnimationState());
        if (!cursor.isAnimated()) {
            state.reset();
            return 0;
        }
        state.nextFrame(cursor);
        return cursor.getFrame(state.getCurrentFrame()).spriteIndex();
    }
}

