/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.screen.CursorAnimationHelper;
import io.github.fishstiz.minecraftcursor.gui.screen.MoreOptionsScreen;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsHandler;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsWidget;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractContainerWidget;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;

public class CursorOptionsScreen
extends Screen {
    private static final Component TITLE_TEXT = Component.translatable((String)"minecraft-cursor.options");
    private static final int CURSORS_COLUMN_WIDTH = 96;
    private static final int SELECTED_CURSOR_COLUMN_WIDTH = 200;
    private static final int COLUMN_GAP = 8;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private final Button moreButton = Button.builder((Component)Component.translatable((String)"minecraft-cursor.options.more").append("..."), btn -> this.toMoreOptions()).build();
    private final Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.onClose()).build();
    public final CursorAnimationHelper animationHelper = new CursorAnimationHelper();
    private final CursorManager cursorManager;
    private final List<Cursor> cursors;
    private final Screen previousScreen;
    private Cursor selectedCursor;
    CursorOptionsBody body;

    public CursorOptionsScreen(Screen previousScreen, CursorManager cursorManager) {
        super(TITLE_TEXT);
        this.previousScreen = previousScreen;
        this.cursorManager = cursorManager;
        this.cursors = this.cursorManager.getLoadedCursors();
    }

    protected void init() {
        this.selectedCursor = this.cursorManager.getLoadedCursors().getFirst();
        this.layout.addTitleHeader(this.title, this.font);
        this.body = (CursorOptionsBody)this.layout.addToContents((LayoutElement)new CursorOptionsBody());
        this.layout.addToFooter((LayoutElement)this.moreButton);
        this.layout.addToFooter((LayoutElement)this.doneButton);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        if (this.body != null) {
            this.repositionElements();
        }
    }

    protected void repositionElements() {
        this.layout.arrangeElements();
        int bodyWidth = 304;
        int buttonWidth = bodyWidth / 2 - 4;
        int centerX = this.width / 2;
        int gapHalf = 4;
        this.moreButton.setWidth(buttonWidth);
        this.doneButton.setWidth(buttonWidth - 2);
        this.moreButton.setX(centerX - buttonWidth - gapHalf);
        this.doneButton.setX(centerX + gapHalf);
        this.body.position();
    }

    public void selectCursor(Cursor cursor) {
        this.updateSelectedCursorConfig();
        this.selectedCursor = cursor;
        if (this.body != null) {
            this.body.selectedCursorColumn.refresh();
        }
    }

    private void updateSelectedCursorConfig() {
        if (this.body != null) {
            this.body.selectedCursorColumn.save();
        }
    }

    public Cursor getSelectedCursor() {
        return this.selectedCursor;
    }

    public List<Cursor> getCursors() {
        return this.cursors;
    }

    public void toMoreOptions() {
        if (this.minecraft != null) {
            this.minecraft.setScreen((Screen)new MoreOptionsScreen(this, this.cursorManager));
        }
    }

    public void onClose() {
        CursorOptionsHandler.removeScaleOverride();
        MinecraftCursor.CONFIG.save();
        if (this.minecraft != null) {
            this.minecraft.setScreen(this.previousScreen);
        }
    }

    public class CursorOptionsBody
    extends AbstractContainerWidget {
        public final CursorListWidget cursorsColumn;
        public final CursorOptionsWidget selectedCursorColumn;

        public CursorOptionsBody() {
            super(CursorOptionsScreen.this.layout.getX(), CursorOptionsScreen.this.layout.getHeaderHeight(), CursorOptionsScreen.this.width, CursorOptionsScreen.this.layout.getContentHeight(), (Component)Component.empty());
            int y = CursorOptionsScreen.this.layout.getHeaderHeight();
            int height = CursorOptionsScreen.this.layout.getContentHeight();
            CursorOptionsScreen screen = CursorOptionsScreen.this;
            this.cursorsColumn = new CursorListWidget(CursorOptionsScreen.this.minecraft, 96, height, y, screen);
            this.selectedCursorColumn = new CursorOptionsWidget(this.computedX2(), 200, height, y, screen);
            this.position();
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
            if (this.cursorsColumn.isMouseOver(mouseX, mouseY)) {
                return this.cursorsColumn.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
            }
            return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
        }

        public List<? extends GuiEventListener> children() {
            return List.of(this.cursorsColumn, this.selectedCursorColumn);
        }

        protected void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
            this.cursorsColumn.renderWidget(context, mouseX, mouseY, delta);
            this.selectedCursorColumn.renderWidget(context, mouseX, mouseY, delta);
        }

        public void position() {
            int width = CursorOptionsScreen.this.width;
            int height = CursorOptionsScreen.this.layout.getContentHeight();
            int y = CursorOptionsScreen.this.layout.getHeaderHeight();
            this.setSize(width, height);
            this.setPosition(0, y);
            this.cursorsColumn.setHeight(height);
            this.selectedCursorColumn.setHeight(height);
            this.cursorsColumn.setPosition(this.computedX(), y);
            this.selectedCursorColumn.setPosition(this.computedX2(), y);
        }

        private int computedX() {
            return CursorOptionsScreen.this.width / 2 - 152;
        }

        private int computedX2() {
            return this.computedX() + 96 + 8;
        }

        protected void updateWidgetNarration(NarrationElementOutput builder) {
        }
    }
}

