/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.gui.screen.CursorOptionsScreen;
import io.github.fishstiz.minecraftcursor.gui.widget.MoreOptionsListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorHotspotWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class MoreOptionsScreen
extends Screen
implements CursorProvider {
    private static final int HOTSPOT_WIDGET_SIZE = 96;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this);
    private final Screen previousScreen;
    private final CursorManager cursorManager;
    @Nullable
    private final SelectedCursorHotspotWidget hotspotWidget;
    private final Button doneButton = Button.builder((Component)CommonComponents.GUI_DONE, btn -> this.onClose()).build();
    private MoreOptionsListWidget list;

    /*
     * Enabled aggressive block sorting
     */
    protected MoreOptionsScreen(Screen previousScreen, CursorManager cursorManager) {
        super((Component)Component.translatable((String)"minecraft-cursor.options.more"));
        this.previousScreen = previousScreen;
        this.cursorManager = cursorManager;
        if (previousScreen instanceof CursorOptionsScreen) {
            CursorOptionsScreen optionsScreen = (CursorOptionsScreen)previousScreen;
            if (optionsScreen.body != null) {
                this.hotspotWidget = new SelectedCursorHotspotWidget(96, optionsScreen.body.selectedCursorColumn);
                this.hotspotWidget.visible = false;
                this.addWidget((GuiEventListener)this.hotspotWidget);
                return;
            }
        }
        this.hotspotWidget = null;
    }

    protected void init() {
        this.layout.addTitleHeader(this.title, this.font);
        this.list = (MoreOptionsListWidget)this.layout.addToContents((LayoutElement)new MoreOptionsListWidget(this.minecraft, this.width, this.layout.getContentHeight(), this.layout.getHeaderHeight(), this.cursorManager));
        if (this.hotspotWidget != null) {
            this.hotspotWidget.setChangeEventListener(this.list::handleChangeHotspotWidget);
        }
        this.layout.addToFooter((LayoutElement)this.doneButton);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
    }

    protected void repositionElements() {
        if (this.list != null) {
            this.layout.arrangeElements();
            this.list.updateSize(this.width, this.layout);
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        if (this.list == null || this.hotspotWidget == null) {
            return;
        }
        if (this.list.isEditingHotspot()) {
            int rowGap = this.list.getRowGap();
            int x = this.list.getRowLeft() - this.hotspotWidget.getWidth() - rowGap;
            int y = this.list.getYEntry(1) + rowGap / 2;
            this.hotspotWidget.setPosition(x, y);
            this.hotspotWidget.visible = true;
            this.hotspotWidget.active = true;
            context.enableScissor(x, this.layout.getHeaderHeight(), this.list.getRowLeft(), this.layout.getHeaderHeight() + this.layout.getContentHeight());
            this.hotspotWidget.render(context, mouseX, mouseY, delta);
            context.disableScissor();
        } else {
            this.hotspotWidget.visible = false;
            this.hotspotWidget.active = false;
        }
    }

    public void onClose() {
        this.list.applyConfig();
        if (this.minecraft != null) {
            Screen screen = this.previousScreen;
            if (screen instanceof CursorOptionsScreen) {
                CursorOptionsScreen screen2 = (CursorOptionsScreen)screen;
                if (screen2.body != null) {
                    screen2.body.selectedCursorColumn.refresh();
                }
            }
            this.minecraft.setScreen(this.previousScreen);
        }
    }

    public CursorType getCursorType(double mouseX, double mouseY) {
        int headerHeight = this.layout.getHeaderHeight();
        if ((mouseY < (double)headerHeight || mouseY > (double)(headerHeight + this.layout.getContentHeight())) && mouseX > (double)(this.doneButton.getX() + this.doneButton.getWidth())) {
            return CursorType.DEFAULT_FORCE;
        }
        return CursorType.DEFAULT;
    }
}

