/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorController;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsWidget;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;

public class CursorOptionsHandler {
    private static final CursorConfig.GlobalSettings GLOBAL = MinecraftCursor.CONFIG.getGlobal();
    private static final int SCALE_OVERRIDE = -1;
    private final CursorOptionsWidget options;

    CursorOptionsHandler(CursorOptionsWidget optionsWidget) {
        this.options = optionsWidget;
    }

    void handleEnable(boolean enabled) {
        Cursor cursor = this.getCursor();
        cursor.enable(enabled);
        this.updateSettings();
        if (cursor instanceof AnimatedCursor) {
            this.options.resetAnimation.active = this.options.animateButton.value && enabled;
        }
    }

    void handleChangeHotspotWidget(int xhot, int yhot) {
        if (!GLOBAL.isXHotActive()) {
            this.options.xhotSlider.setTranslatedValue(xhot);
            this.handleChangeXHot(xhot);
        }
        if (!GLOBAL.isYHotActive()) {
            this.options.yhotSlider.setTranslatedValue(yhot);
            this.handleChangeYHot(yhot);
        }
    }

    Consumer<Double> handleChangeHotspots(DoubleConsumer handleChangeHotspot) {
        return value -> {
            handleChangeHotspot.accept((double)value);
            this.options.cursorHotspot.setRulerRendered(true, true);
        };
    }

    void handlePressAnimate(boolean animated) {
        this.getCursorAsAnimatedCursor().ifPresent(animatedCursor -> {
            animatedCursor.setAnimated(animated);
            this.getSettings().setAnimated(animatedCursor.isAnimated());
            this.options.resetAnimation.active = this.options.enableButton.value && animated;
        });
        if (!animated) {
            this.options.cursorHotspot.setRulerRendered(true, true);
        }
    }

    void handleResetAnimation() {
        this.getCursorAsAnimatedCursor().ifPresent(animatedCursor -> this.options.parent().animationHelper.reset((AnimatedCursor)animatedCursor));
        this.options.cursorHotspot.setRulerRendered(false, false);
    }

    void handleChangeScale(double scale) {
        Cursor cursor = this.getCursor();
        if (cursor.getScale() != scale) {
            CursorController.getInstance().overrideCursor(cursor.getType(), -1);
        }
        cursor.setScale(scale);
        this.updateSettings();
    }

    void handleChangeXHot(double xhot) {
        this.getCursor().setXHot((int)xhot);
        this.updateSettings();
    }

    void handleChangeYHot(double yhot) {
        this.getCursor().setYHot((int)yhot);
        this.updateSettings();
    }

    Cursor getCursor() {
        return this.options.parent().getSelectedCursor();
    }

    Optional<AnimatedCursor> getCursorAsAnimatedCursor() {
        Optional<AnimatedCursor> optional;
        Cursor cursor = this.getCursor();
        if (cursor instanceof AnimatedCursor) {
            AnimatedCursor animatedCursor = (AnimatedCursor)cursor;
            optional = Optional.of(animatedCursor);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    boolean isAnimated() {
        return this.getCursorAsAnimatedCursor().map(AnimatedCursor::isAnimated).orElse(false);
    }

    CursorConfig.Settings getSettings() {
        return MinecraftCursor.CONFIG.getOrCreateCursorSettings(this.getCursor().getType());
    }

    public void updateSettings() {
        CursorConfig.Settings settings = this.getSettings();
        Cursor cursor = this.getCursor();
        this.getSettings().update(GLOBAL.isScaleActive() ? settings.getScale() : cursor.getScale(), GLOBAL.isXHotActive() ? settings.getXHot() : cursor.getXHot(), GLOBAL.isYHotActive() ? settings.getYHot() : cursor.getYHot(), cursor.isEnabled());
    }

    public static void removeScaleOverride() {
        CursorController.getInstance().removeOverride(-1);
    }
}

