/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.gui.screen.CursorOptionsScreen;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsHandler;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorButtonWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorHotspotWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorSliderWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorTestWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorToggleWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleConsumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractContainerWidget;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CursorOptionsWidget
extends AbstractContainerWidget {
    private static final int OPTIONS_HEIGHT = 24;
    private static final int GRID_PADDING = 4;
    private static final int BOX_WIDGET_TEXTURE_SIZE = 96;
    private static final int HELPER_BUTTON_SIZE = 16;
    private static final int HELPER_ICON_SIZE = 10;
    private static final ResourceLocation HELPER_ICON = ResourceLocation.withDefaultNamespace((String)"textures/gui/sprites/icon/unseen_notification.png");
    private static final String GLOBAL_TEXT_KEY = "minecraft-cursor.options.global.tooltip";
    private static final Component ANIMATE_TEXT = Component.translatable((String)"minecraft-cursor.options.animate");
    private static final Component RESET_ANIMATION_TEXT = Component.translatable((String)"minecraft-cursor.options.animate-reset");
    private static final String HOT_UNIT = "px";
    public static final Component ENABLED_TEXT = Component.translatable((String)"minecraft-cursor.options.enabled");
    public static final Component SCALE_TEXT = Component.translatable((String)"minecraft-cursor.options.scale");
    public static final Component XHOT_TEXT = Component.translatable((String)"minecraft-cursor.options.xhot");
    public static final Component YHOT_TEXT = Component.translatable((String)"minecraft-cursor.options.yhot");
    private final CursorOptionsScreen parent;
    private final CursorOptionsHandler handler;
    SelectedCursorToggleWidget enableButton;
    SelectedCursorSliderWidget scaleSlider;
    SelectedCursorSliderWidget xhotSlider;
    SelectedCursorSliderWidget yhotSlider;
    SelectedCursorToggleWidget animateButton;
    SelectedCursorButtonWidget resetAnimation;
    SelectedCursorHotspotWidget cursorHotspot;
    SelectedCursorTestWidget cursorTest;

    public CursorOptionsWidget(int x, int width, int height, int y, CursorOptionsScreen optionsScreen) {
        super(x, y, width, height, (Component)Component.empty());
        this.parent = optionsScreen;
        this.handler = new CursorOptionsHandler(this);
        this.initWidgets();
    }

    private void initWidgets() {
        CursorConfig.Settings settings = this.handler.getSettings();
        this.enableButton = new SelectedCursorToggleWidget(ENABLED_TEXT, settings.isEnabled(), this.handler::handleEnable);
        this.scaleSlider = new SelectedCursorSliderWidget(SCALE_TEXT, settings.getScale(), 0.5, 3.0, 0.05, this.handler::handleChangeScale, CursorOptionsHandler::removeScaleOverride);
        this.bindHelperButton(this.scaleSlider);
        this.xhotSlider = this.createHotspotSlider(XHOT_TEXT, settings.getXHot(), this.handler::handleChangeXHot);
        this.yhotSlider = this.createHotspotSlider(YHOT_TEXT, settings.getYHot(), this.handler::handleChangeYHot);
        this.animateButton = new SelectedCursorToggleWidget(ANIMATE_TEXT, this.handler.isAnimated(), this.handler::handlePressAnimate);
        this.resetAnimation = new SelectedCursorButtonWidget(RESET_ANIMATION_TEXT, this.handler::handleResetAnimation);
        this.cursorHotspot = new SelectedCursorHotspotWidget(96, this);
        this.cursorHotspot.setChangeEventListener(this.handler::handleChangeHotspotWidget);
        this.cursorTest = new SelectedCursorTestWidget(96, this);
        this.refreshWidgets();
    }

    private SelectedCursorSliderWidget createHotspotSlider(Component prefix, int value, DoubleConsumer onApply) {
        SelectedCursorSliderWidget slider = new SelectedCursorSliderWidget(prefix, (double)value, 0.0, 31.0, 1.0, HOT_UNIT, this.handler.handleChangeHotspots(onApply));
        this.bindHelperButton(slider);
        return slider;
    }

    private void bindHelperButton(SelectedCursorSliderWidget sliderWidget) {
        SelectedCursorButtonWidget helperButton = new SelectedCursorButtonWidget(HELPER_ICON, 10, 10, this.parent::toMoreOptions);
        helperButton.setTooltip(Tooltip.create((Component)Component.translatable((String)GLOBAL_TEXT_KEY, (Object[])new Object[]{sliderWidget.getPrefix()})));
        sliderWidget.setInactiveHelperButton(helperButton, 16, 16);
    }

    private void refreshWidgets() {
        CursorConfig.GlobalSettings global = MinecraftCursor.CONFIG.getGlobal();
        CursorConfig.Settings settings = this.handler.getSettings();
        this.enableButton.setValue(settings.isEnabled());
        this.scaleSlider.update(settings.getScale(), !global.isScaleActive());
        this.xhotSlider.update(settings.getXHot(), !global.isXHotActive());
        this.yhotSlider.update(settings.getYHot(), !global.isYHotActive());
        boolean isAnimated = this.handler.isAnimated();
        this.animateButton.active = this.handler.getCursorAsAnimatedCursor().isPresent();
        this.resetAnimation.active = isAnimated && this.enableButton.value;
        this.animateButton.setValue(isAnimated);
        this.cursorHotspot.setRulerRendered(true, true);
        this.cursorHotspot.active = !global.isXHotActive() || !global.isYHotActive();
        this.children().forEach(widget -> widget.setFocused(false));
    }

    public void renderWidget(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.placeWidgets();
        this.enableButton.render(context, mouseX, mouseY, delta);
        this.scaleSlider.renderWidget(context, mouseX, mouseY, delta);
        this.xhotSlider.renderWidget(context, mouseX, mouseY, delta);
        this.yhotSlider.renderWidget(context, mouseX, mouseY, delta);
        if (this.handler.getCursorAsAnimatedCursor().isPresent()) {
            this.animateButton.render(context, mouseX, mouseY, delta);
            this.resetAnimation.render(context, mouseX, mouseY, delta);
        }
        this.cursorHotspot.renderWidget(context, mouseX, mouseY, delta);
        this.cursorTest.renderWidget(context, mouseX, mouseY, delta);
    }

    private void placeWidgets() {
        boolean isAnimatedCursor = this.handler.getCursorAsAnimatedCursor().isPresent();
        this.grid((AbstractWidget)this.enableButton, 0, 0);
        this.grid((AbstractWidget)this.scaleSlider, 1, 0);
        this.grid((AbstractWidget)this.xhotSlider, 0, 1);
        this.grid((AbstractWidget)this.yhotSlider, 1, 1);
        if (isAnimatedCursor) {
            this.grid((AbstractWidget)this.animateButton, 0, 2);
            this.grid((AbstractWidget)this.resetAnimation, 1, 2);
            this.grid(this.cursorHotspot, 0, 3, true);
            this.grid(this.cursorTest, 1, 3, true);
        } else {
            this.grid(this.cursorHotspot, 0, 2, true);
            this.grid(this.cursorTest, 1, 2, true);
        }
    }

    private void grid(AbstractWidget widget, int gridX, int gridY) {
        this.grid(widget, gridX, gridY, false);
    }

    private void grid(AbstractWidget widget, int gridX, int gridY, boolean absolute) {
        if (!absolute) {
            widget.setWidth(this.getWidth() / 2 - 4);
            widget.setHeight(20);
        }
        widget.setX(this.getX() + this.getWidth() / 2 * gridX);
        widget.setY(this.getY() + 24 * gridY);
    }

    public void save() {
        this.handler.updateSettings();
    }

    public void refresh() {
        this.refreshWidgets();
    }

    public CursorOptionsScreen parent() {
        return this.parent;
    }

    public List<? extends GuiEventListener> children() {
        ArrayList<SelectedCursorTestWidget> children = new ArrayList<SelectedCursorTestWidget>(List.of(this.enableButton, this.scaleSlider, this.xhotSlider, this.yhotSlider, this.animateButton, this.resetAnimation, this.cursorHotspot, this.cursorTest));
        this.addHelperButton(this.scaleSlider, children);
        this.addHelperButton(this.xhotSlider, children);
        this.addHelperButton(this.yhotSlider, children);
        return children;
    }

    private void addHelperButton(SelectedCursorSliderWidget slider, List<GuiEventListener> children) {
        SelectedCursorButtonWidget helperButton;
        if (slider != null && (helperButton = slider.getInactiveHelperButton()) != null) {
            children.add((GuiEventListener)helperButton);
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput builder) {
    }
}

