/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorButtonWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorSliderWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorToggleWidget;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import io.github.fishstiz.minecraftcursor.util.MouseEvent;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.Nullable;

public class MoreOptionsListWidget
extends ContainerObjectSelectionList<OptionEntry> {
    private static final CursorConfig.GlobalSettings GLOBAL = MinecraftCursor.CONFIG.getGlobal();
    private static final String GLOBAL_TOOLTIP_KEY = "minecraft-cursor.options.more.global.tooltip";
    private static final Component GLOBAL_SETTINGS_TEXT = Component.translatable((String)"minecraft-cursor.options.more.global");
    private static final Tooltip ANIMATION_TOOLTIP = Tooltip.create((Component)Component.translatable((String)"minecraft-cursor.options.more.animation.tooltip"));
    private static final Component ANIMATION_TEXT = Component.translatable((String)"minecraft-cursor.options.more.animation");
    private static final Tooltip ADAPTIVE_CURSOR_TOOLTIP = Tooltip.create((Component)Component.translatable((String)"minecraft-cursor.options.more.adapt.tooltip"));
    private static final Component ADAPTIVE_CURSOR_TEXT = Component.translatable((String)"minecraft-cursor.options.more.adapt");
    private static final Component ITEM_SLOT_TEXT = Component.translatable((String)"minecraft-cursor.options.item_slot");
    private static final Component ITEM_GRAB_TEXT = Component.translatable((String)"minecraft-cursor.options.item_grab");
    private static final Component CREATIVE_TABS_TEXT = Component.translatable((String)"minecraft-cursor.options.creative_tabs");
    private static final Component ENCHANTMENTS_TEXT = Component.translatable((String)"minecraft-cursor.options.enchantments");
    private static final Component STONECUTTER_TEXT = Component.translatable((String)"minecraft-cursor.options.stonecutter");
    private static final Component BOOK_EDIT_TEXT = Component.translatable((String)"minecraft-cursor.options.book_edit");
    private static final Component LOOM_TEXT = Component.translatable((String)"minecraft-cursor.options.loom");
    private static final Component ADVANCEMENTS_TEXT = Component.translatable((String)"minecraft-cursor.options.advancements");
    private static final Component WORLD_ICON_TEXT = Component.translatable((String)"minecraft-cursor.options.world");
    private static final Component SERVER_ICON_TEXT = Component.translatable((String)"minecraft-cursor.options.server");
    private static final Component RESOURCE_TEXT = Component.translatable((String)"minecraft-cursor.options.more.resource_pack");
    private static final Component RESOURCE_RELOAD_TEXT = Component.translatable((String)"minecraft-cursor.options.more.resource_pack.reset");
    private static final Component RESOURCE_RELOAD_TOOLTIP_TEXT = Component.translatable((String)"minecraft-cursor.options.more.resource_pack.reset.tooltip");
    private static final Component COMPAT_TEXT = Component.translatable((String)"minecraft-cursor.options.more.compat");
    private static final Component REMAP_TEXT = Component.translatable((String)"minecraft-cursor.options.more.compat.remap_cursors");
    private static final Tooltip REMAP_TOOLTIP = Tooltip.create((Component)Component.translatable((String)"minecraft-cursor.options.more.compat.remap_cursors.tooltip"));
    private static final int BUTTON_WIDTH = 40;
    private static final int ITEM_HEIGHT = 20;
    private static final int ROW_GAP = 6;
    private final CursorManager cursorManager;
    private final List<ToggleEntry> adaptiveOptions = new ArrayList<ToggleEntry>();
    private final ToggleEntry animationEntry = new ToggleEntry(this, ANIMATION_TEXT, false, false, ANIMATION_TOOLTIP, this::toggleAnimations);
    private final SliderEntry scaleEntry = this.createSliderEntry(CursorOptionsWidget.SCALE_TEXT, "", 0.5, 3.0, 0.05, GLOBAL::isScaleActive, GLOBAL::setScaleActive, GLOBAL::getScale, GLOBAL::setScale, CursorConfig.Settings::getScale, Cursor::setScale);
    private final SliderEntry xhotEntry = this.createSliderEntry(CursorOptionsWidget.XHOT_TEXT, "px", 0.0, 31.0, 1.0, GLOBAL::isXHotActive, GLOBAL::setXhotActive, GLOBAL::getXHot, GLOBAL::setXHotDouble, CursorConfig.Settings::getXHot, Cursor::setXHot);
    private final SliderEntry yhotEntry = this.createSliderEntry(CursorOptionsWidget.YHOT_TEXT, "px", 0.0, 31.0, 1.0, GLOBAL::isYHotActive, GLOBAL::setYhotActive, GLOBAL::getYHot, GLOBAL::setYHotDouble, CursorConfig.Settings::getYHot, Cursor::setYHot);

    public MoreOptionsListWidget(Minecraft minecraftClient, int width, int height, int y, CursorManager cursorManager) {
        super(minecraftClient, width, height, y, 26);
        this.cursorManager = cursorManager;
        this.addGlobalOptions();
        this.addAdaptiveOptions();
        this.addModCompatOptions();
        this.addResourcePackOptions();
    }

    private void addGlobalOptions() {
        this.addEntry((AbstractSelectionList.Entry)new TitleEntry(GLOBAL_SETTINGS_TEXT));
        this.reloadGlobalOptions();
        this.addEntry((AbstractSelectionList.Entry)this.animationEntry);
        this.addEntry((AbstractSelectionList.Entry)this.scaleEntry);
        this.addEntry((AbstractSelectionList.Entry)this.xhotEntry);
        this.addEntry((AbstractSelectionList.Entry)this.yhotEntry);
    }

    private void reloadGlobalOptions() {
        try {
            ((ToggleWidget)this.animationEntry.button).setValue(this.cursorManager.isAnimated());
            ((ToggleWidget)this.animationEntry.button).active = this.cursorManager.hasAnimations();
            ((ToggleWidget)this.scaleEntry.button).setValue(GLOBAL.isScaleActive());
            ((ToggleWidget)this.xhotEntry.button).setValue(GLOBAL.isXHotActive());
            ((ToggleWidget)this.yhotEntry.button).setValue(GLOBAL.isYHotActive());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void addAdaptiveOptions() {
        boolean isAdaptive = this.cursorManager.isAdaptive();
        this.addEntry((AbstractSelectionList.Entry)new TitleEntry(ADAPTIVE_CURSOR_TEXT));
        this.addEntry((AbstractSelectionList.Entry)new ToggleEntry(this, CursorOptionsWidget.ENABLED_TEXT, isAdaptive, true, ADAPTIVE_CURSOR_TOOLTIP, this::toggleAdaptive));
        this.addAdaptiveEntry(ITEM_SLOT_TEXT, MinecraftCursor.CONFIG.isItemSlotEnabled(), isAdaptive, MinecraftCursor.CONFIG::setItemSlotEnabled);
        this.addAdaptiveEntry(ITEM_GRAB_TEXT, MinecraftCursor.CONFIG.isItemGrabbingEnabled(), isAdaptive, MinecraftCursor.CONFIG::setItemGrabbingEnabled);
        this.addAdaptiveEntry(CREATIVE_TABS_TEXT, MinecraftCursor.CONFIG.isCreativeTabsEnabled(), isAdaptive, MinecraftCursor.CONFIG::setCreativeTabsEnabled);
        this.addAdaptiveEntry(ENCHANTMENTS_TEXT, MinecraftCursor.CONFIG.isEnchantmentsEnabled(), isAdaptive, MinecraftCursor.CONFIG::setEnchantmentsEnabled);
        this.addAdaptiveEntry(STONECUTTER_TEXT, MinecraftCursor.CONFIG.isStonecutterRecipesEnabled(), isAdaptive, MinecraftCursor.CONFIG::setStonecutterRecipesEnabled);
        this.addAdaptiveEntry(BOOK_EDIT_TEXT, MinecraftCursor.CONFIG.isBookEditEnabled(), isAdaptive, MinecraftCursor.CONFIG::setBookEditEnabled);
        this.addAdaptiveEntry(LOOM_TEXT, MinecraftCursor.CONFIG.isLoomPatternsEnabled(), isAdaptive, MinecraftCursor.CONFIG::setLoomPatternsEnabled);
        this.addAdaptiveEntry(ADVANCEMENTS_TEXT, MinecraftCursor.CONFIG.isAdvancementTabsEnabled(), isAdaptive, MinecraftCursor.CONFIG::setAdvancementTabsEnabled);
        this.addAdaptiveEntry(WORLD_ICON_TEXT, MinecraftCursor.CONFIG.isWorldIconEnabled(), isAdaptive, MinecraftCursor.CONFIG::setWorldIconEnabled);
        this.addAdaptiveEntry(SERVER_ICON_TEXT, MinecraftCursor.CONFIG.isServerIconEnabled(), isAdaptive, MinecraftCursor.CONFIG::setServerIconEnabled);
    }

    private void addModCompatOptions() {
        this.addEntry((AbstractSelectionList.Entry)new TitleEntry(COMPAT_TEXT));
        this.addEntry((AbstractSelectionList.Entry)new ToggleEntry(this, REMAP_TEXT, MinecraftCursor.CONFIG.isRemapCursorsEnabled(), true, REMAP_TOOLTIP, MinecraftCursor.CONFIG::setRemapCursorsEnabled));
    }

    private void addResourcePackOptions() {
        this.addEntry((AbstractSelectionList.Entry)new TitleEntry(RESOURCE_TEXT));
        this.addEntry((AbstractSelectionList.Entry)new FullButtonEntry(RESOURCE_RELOAD_TEXT, RESOURCE_RELOAD_TOOLTIP_TEXT, this::reloadConfiguration));
    }

    private void reloadConfiguration() {
        MinecraftCursor.CONFIG.set_hash(String.valueOf(Math.random()));
        this.minecraft.reloadResourcePacks().thenRun(this::reloadGlobalOptions);
    }

    private void addAdaptiveEntry(Component label, boolean isEnabled, boolean active, Consumer<Boolean> onPress) {
        ToggleEntry entry = new ToggleEntry(this, label, isEnabled, active, onPress);
        this.adaptiveOptions.add(entry);
        this.addEntry((AbstractSelectionList.Entry)entry);
    }

    private SliderEntry createSliderEntry(Component text, String suffix, double min, double max, double step, BooleanSupplier activeGetter, BooleanConsumer activeSetter, DoubleSupplier valueGetter, DoubleConsumer valueSetter, ToDoubleFunction<CursorConfig.Settings> settingsValueGetter, ObjDoubleConsumer<Cursor> cursorAction) {
        Runnable updateCursors = () -> this.cursorManager.getLoadedCursors().forEach(cursor -> {
            double value = activeGetter.getAsBoolean() ? valueGetter.getAsDouble() : settingsValueGetter.applyAsDouble(MinecraftCursor.CONFIG.getOrCreateCursorSettings(cursor.getType()));
            cursorAction.accept((Cursor)cursor, value);
        });
        DoubleConsumer handleChange = value -> {
            valueSetter.accept(value);
            cursorAction.accept(this.cursorManager.getCurrentCursor(), value);
        };
        BooleanConsumer handleToggle = active -> {
            activeSetter.accept(active);
            updateCursors.run();
        };
        SliderEntry.Slider slider = new SliderEntry.Slider(text, suffix, valueGetter.getAsDouble(), min, max, step, handleChange::accept);
        SliderEntry.Toggle toggle = new SliderEntry.Toggle(CursorOptionsWidget.ENABLED_TEXT, activeGetter.getAsBoolean(), MoreOptionsListWidget.getSettingTooltip(text), (Consumer<Boolean>)handleToggle);
        return new SliderEntry(slider, toggle, updateCursors);
    }

    public void handleChangeHotspotWidget(MouseEvent mouseEvent, int xhot, int yhot) {
        boolean applyX = GLOBAL.isXHotActive();
        boolean applyY = GLOBAL.isYHotActive();
        if (applyX) {
            GLOBAL.setXHot(xhot);
            this.xhotEntry.sliderWidget.setTranslatedValue(xhot);
        }
        if (applyY) {
            GLOBAL.setYHot(yhot);
            this.yhotEntry.sliderWidget.setTranslatedValue(yhot);
        }
        if (applyX && applyY) {
            this.cursorManager.getCurrentCursor().setHotspots(xhot, yhot);
        } else if (applyX) {
            this.cursorManager.getCurrentCursor().setXHot(xhot);
        } else if (applyY) {
            this.cursorManager.getCurrentCursor().setYHot(yhot);
        }
        if (mouseEvent == MouseEvent.RELEASE) {
            this.applyHotspotsToAll();
        }
    }

    private void applyHotspotsToAll() {
        boolean applyX = GLOBAL.isXHotActive();
        boolean applyY = GLOBAL.isYHotActive();
        if (applyX && applyY) {
            this.cursorManager.getLoadedCursors().forEach(cursor -> cursor.setHotspots(GLOBAL.getXHot(), GLOBAL.getYHot()));
        } else if (applyX) {
            this.cursorManager.getLoadedCursors().forEach(cursor -> cursor.setXHot(GLOBAL.getXHot()));
        } else if (applyY) {
            this.cursorManager.getLoadedCursors().forEach(cursor -> cursor.setYHot(GLOBAL.getYHot()));
        }
    }

    private void applyScaleToAll() {
        if (GLOBAL.isScaleActive()) {
            this.cursorManager.getLoadedCursors().forEach(cursor -> cursor.setScale(GLOBAL.getScale()));
        }
    }

    public void applyConfig() {
        this.applyScaleToAll();
        this.applyHotspotsToAll();
    }

    private void toggleAnimations(boolean isAnimated) {
        this.cursorManager.setIsAnimated(isAnimated);
        MinecraftCursor.CONFIG.getSettings().forEach((key, settings) -> {
            if (this.cursorManager.getCursor((String)key) instanceof AnimatedCursor) {
                settings.setAnimated(isAnimated);
            }
        });
    }

    private void toggleAdaptive(boolean isEnabled) {
        this.adaptiveOptions.forEach(option -> {
            ((ToggleWidget)option.button).active = isEnabled;
            ((ToggleWidget)option.button).setValue(isEnabled);
        });
        this.cursorManager.setIsAdaptive(isEnabled);
        MinecraftCursor.CONFIG.getSettings().forEach((key, settings) -> {
            if (key.equals(CursorType.DEFAULT.getKey())) {
                return;
            }
            settings.update(settings.getScale(), settings.getXHot(), settings.getYHot(), isEnabled);
        });
    }

    public int getYEntry(int index) {
        return this.getY() + this.itemHeight * index + 6 - (int)Math.round(this.getScrollAmount());
    }

    public int getRowGap() {
        return 6;
    }

    public boolean isEditingHotspot() {
        return !(!GLOBAL.isXHotActive() && !GLOBAL.isYHotActive() || !this.xhotEntry.isFocused() && !this.yhotEntry.isFocused());
    }

    public ToggleWidget createToggleWidget(boolean defaultValue, Tooltip tooltip, Consumer<Boolean> onPress) {
        return new ToggleWidget(this.getRowRight() - 40, this.getY() + this.itemHeight * this.getItemCount() + 6, 40, this.itemHeight - 6, defaultValue, tooltip, onPress);
    }

    public static Tooltip getSettingTooltip(Component settingText) {
        return Tooltip.create((Component)Component.translatable((String)GLOBAL_TOOLTIP_KEY, (Object[])new Object[]{settingText}));
    }

    public class ToggleEntry
    extends LabeledButtonEntry<ToggleWidget> {
        public ToggleEntry(MoreOptionsListWidget this$0, Component label, boolean defaultValue, boolean active, Consumer<Boolean> onPress) {
            this(this$0, label, defaultValue, active, null, onPress);
        }

        public ToggleEntry(MoreOptionsListWidget this$0, Component label, boolean defaultValue, @Nullable boolean active, Tooltip tooltip, Consumer<Boolean> onPress) {
            super(label, () -> this$0.createToggleWidget(defaultValue, tooltip, onPress));
            ((ToggleWidget)this.button).active = active;
        }
    }

    public class SliderEntry
    extends ToggleEntry {
        private final SelectedCursorSliderWidget sliderWidget;

        public SliderEntry(Slider slider, Toggle toggle, Runnable onRelease) {
            super(MoreOptionsListWidget.this, (Component)Component.empty(), toggle.value, true, toggle.tooltip, toggle.toggleFunction);
            this.sliderWidget = new SelectedCursorSliderWidget(slider.label, slider.value, slider.min, slider.max, slider.step, slider.suffix, slider.applyFunction, onRelease);
        }

        @Override
        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            super.render(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            this.sliderWidget.active = ((ToggleWidget)this.button).value;
            this.sliderWidget.setPosition(x - 3, MoreOptionsListWidget.this.getYEntry(index));
            this.sliderWidget.setSize(((ToggleWidget)this.button).getX() - x - 6, 20);
            this.sliderWidget.renderWidget(context, mouseX, mouseY, tickDelta);
        }

        @Override
        protected List<AbstractWidget> getChildren() {
            return List.of(this.sliderWidget, this.button);
        }

        public record Toggle(Component label, boolean value, Tooltip tooltip, Consumer<Boolean> toggleFunction) {
        }

        public record Slider(Component label, String suffix, double value, double min, double max, double step, Consumer<Double> applyFunction) {
        }
    }

    public class TitleEntry
    extends OptionEntry {
        public TitleEntry(Component label) {
            super((Component)Component.empty().append(label).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.YELLOW}));
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int itemY = Math.round((float)y + (float)entryHeight / 3.0f);
            int titleX = x + (MoreOptionsListWidget.this.getRowWidth() / 2 - ((MoreOptionsListWidget)MoreOptionsListWidget.this).minecraft.font.width((FormattedText)this.label) / 2);
            context.drawString(((MoreOptionsListWidget)MoreOptionsListWidget.this).minecraft.font, this.label, titleX, itemY, -1, false);
        }

        @Override
        protected List<AbstractWidget> getChildren() {
            return List.of();
        }
    }

    public static class ToggleWidget
    extends SelectedCursorToggleWidget {
        protected ToggleWidget(int x, int y, int width, int height, boolean defaultValue, @Nullable Tooltip tooltip, Consumer<Boolean> onPress) {
            super(x, y, width, height, (Component)Component.empty(), defaultValue, onPress);
            if (tooltip != null) {
                this.setTooltip(tooltip);
            }
        }

        @Override
        protected void updateMessage() {
            this.setMessage(this.value ? CommonComponents.OPTION_ON : CommonComponents.OPTION_OFF);
        }
    }

    public class FullButtonEntry
    extends OptionEntry {
        private final SelectedCursorButtonWidget button;

        protected FullButtonEntry(Component label, Component tooltipText, Runnable onPress) {
            super(label);
            this.button = new SelectedCursorButtonWidget(label, onPress);
            this.button.setSize(MoreOptionsListWidget.this.getRowWidth(), 20);
            this.button.setTooltip(Tooltip.create((Component)tooltipText));
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.button.setPosition(MoreOptionsListWidget.this.getRowLeft(), MoreOptionsListWidget.this.getYEntry(index));
            this.button.render(context, mouseX, mouseY, tickDelta);
        }

        @Override
        protected List<AbstractWidget> getChildren() {
            return List.of(this.button);
        }
    }

    public class LabeledButtonEntry<T extends AbstractWidget>
    extends OptionEntry {
        protected final T button;

        protected LabeledButtonEntry(Component label, Supplier<T> buttonFactory) {
            super(label);
            this.button = (AbstractWidget)buttonFactory.get();
            this.button.setSize(40, 20);
        }

        public void render(GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.button.setX(MoreOptionsListWidget.this.getRowRight() - 40);
            this.button.setY(MoreOptionsListWidget.this.getYEntry(index));
            this.button.render(context, mouseX, mouseY, tickDelta);
            int textEndX = this.button.getX() - 6;
            int textEndY = y + entryHeight;
            int textColor = -1;
            DrawUtil.drawScrollableTextLeftAlign(context, ((MoreOptionsListWidget)MoreOptionsListWidget.this).minecraft.font, this.label, x, y, textEndX, textEndY, textColor);
        }

        @Override
        protected List<AbstractWidget> getChildren() {
            return List.of(this.button);
        }
    }

    public static abstract class OptionEntry
    extends ContainerObjectSelectionList.Entry<OptionEntry> {
        protected final Component label;

        protected OptionEntry(Component label) {
            this.label = label;
        }

        public List<? extends NarratableEntry> narratables() {
            return this.getChildren();
        }

        public List<? extends GuiEventListener> children() {
            return this.getChildren();
        }

        protected abstract List<AbstractWidget> getChildren();
    }
}

