/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.util;

public class SettingsUtil {
    private SettingsUtil() {
    }

    public static double sanitizeScale(double scale) {
        double clampedScale = SettingsUtil.clamp(scale, 0.5, 3.0);
        double mappedScale = (double)Math.round(clampedScale / 0.05) * 0.05;
        return (double)Math.round(mappedScale * 100.0) / 100.0;
    }

    public static int sanitizeHotspot(int hotspot) {
        return SettingsUtil.clamp(hotspot, 0, 31);
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }
}

