package io.github.fishstiz.cursors_extended.compat;

import net.minecraft.class_11875;

public record ModCursor(long handle, String source, class_11875 cursorType, boolean custom) {
    public ModCursor(long handle, String source, class_11875 cursorType) {
        this(handle, source, cursorType, false);
    }

    public static ModCursor ofUnknownType(long handle, String source) {
        return new ModCursor(handle, source, new UnknownType(source, handle), true);
    }

    public static boolean isUnknown(class_11875 cursorType) {
        return cursorType instanceof UnknownType;
    }

    private static final class UnknownType extends class_11875 {
        public UnknownType(String source, long handle) {
            super("cursors_extended/unknown_cursor/" + source + "/" + handle, handle);
        }
    }
}
