package io.github.fishstiz.cursors_extended.gui.widget;

import static io.github.fishstiz.cursors_extended.util.SettingsUtil.clamp;

import net.minecraft.class_310;
import net.minecraft.class_4265;

public abstract class AbstractListWidget<E extends AbstractListWidget<E>.Entry> extends class_4265<E> {
    protected final int rowGap;

    protected AbstractListWidget(class_310 minecraft, int width, int y, int height, int itemHeight) {
        super(minecraft, width, y, height, itemHeight);

        this.rowGap = 0;
    }

    protected AbstractListWidget(class_310 minecraft, int width, int y, int height, int itemHeight, int rowGap) {
        super(minecraft, width, y, height, itemHeight + rowGap);

        this.rowGap = rowGap;
    }

    @Override
    public int method_44390() {
        return Math.max(0, super.method_44390());
    }

    public void setClampedScrollAmount(double scrollAmount) {
        this.method_44382(clamp(scrollAmount, 0d, this.method_44390()));
    }

    public void clampScrollAmount() {
        this.setClampedScrollAmount(this.method_44387());
    }

    @Override
    protected int method_65507() {
        return this.method_55442() - field_55258;
    }

    @Override
    public int method_25322() {
        return this.method_44392() ? this.method_25368() - field_55258 : this.method_25368();
    }

    @Override
    public int method_25342() {
        return this.method_46426();
    }

    @Override
    public int method_25337(int index) {
        return this.method_46427() - (int) this.method_44387() + index * this.field_62109;
    }

    @Override
    public void method_53533(int height) {
        super.method_53533(height);
        this.clampScrollAmount();
    }

    @Override
    public void method_55445(int width, int height) {
        super.method_55445(width, height);
        this.clampScrollAmount();
    }

    @Override
    protected int method_44395() {
        return this.method_25340() * this.field_62109 - this.rowGap;
    }

    protected abstract class Entry extends class_4265.class_4266<E> {
        private final int index;

        protected Entry(int index) {
            this.index = index;
        }

        protected Entry() {
            this(AbstractListWidget.this.method_25396().size());
        }

        @Override
        public int method_46426() {
            return AbstractListWidget.this.method_25342();
        }

        @Override
        public int method_46427() {
            return AbstractListWidget.this.method_25337(this.index);
        }

        @Override
        public int method_25368() {
            return AbstractListWidget.this.method_25322();
        }

        @Override
        public int method_25364() {
            return AbstractListWidget.this.field_62109 - AbstractListWidget.this.rowGap;
        }

        public int getRight() {
            return this.method_46426() + this.method_25368();
        }

        public int getBottom() {
            return this.method_46427() + this.method_25364();
        }

        @Override
        public boolean method_25405(double mouseX, double mouseY) {
            return mouseX >= this.method_46426() &&
                   mouseX <= this.getRight() &&
                   mouseY >= this.method_46427() &&
                   mouseY <= this.getBottom() + AbstractListWidget.this.rowGap;
        }
    }
}
