package io.github.fishstiz.cursors_extended.gui.widget;

import io.github.fishstiz.cursors_extended.gui.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.function.Consumer;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_357;
import net.minecraft.class_5250;

import static net.minecraft.class_4185.field_39500;

public class SliderWidget extends class_357 {
    private final Consumer<Double> listener;
    private final class_2561 prefix;
    private final @Nullable class_2561 suffix;
    private final @Nullable TextMapper textMapper;
    private final @Nullable MouseEventListener mouseEventListener;
    private final double min;
    private final double max;
    private final double step;
    private double mappedValue;
    private double previousAppliedValue;

    public SliderWidget(
            int x,
            int y,
            int width,
            int height,
            double mappedValue,
            double min,
            double max,
            double step,
            @NotNull Consumer<Double> listener,
            @NotNull class_2561 prefix,
            @Nullable class_2561 suffix,
            @Nullable TextMapper textMapper,
            @Nullable MouseEventListener mouseEventListener
    ) {
        super(x, y, width, height, prefix, mappedValue);

        this.listener = listener;
        this.prefix = prefix;
        this.suffix = suffix;
        this.textMapper = textMapper;
        this.min = min;
        this.max = max;
        this.step = step;
        this.mappedValue = mappedValue;
        this.mouseEventListener = mouseEventListener;

        this.field_22753 = this.unmapValue(this.mappedValue);

        this.mapValue();
        this.method_25346();

        this.previousAppliedValue = this.mappedValue;
    }

    public SliderWidget(
            double mappedValue,
            double min,
            double max,
            double step,
            @NotNull Consumer<Double> listener,
            @NotNull class_2561 prefix,
            @Nullable class_2561 suffix,
            @Nullable TextMapper textMapper,
            @Nullable MouseEventListener mouseEventListener
    ) {
        this(0, 0, field_39500, field_60708, mappedValue, min, max, step, listener, prefix, suffix, textMapper, mouseEventListener);
    }

    public SliderWidget(
            double mappedValue,
            double min,
            double max,
            double step,
            @NotNull Consumer<Double> listener,
            @NotNull class_2561 prefix,
            @Nullable class_2561 suffix
    ) {
        this(0, 0, field_39500, field_60708, mappedValue, min, max, step, listener, prefix, suffix, null, null);
    }

    @Override
    protected void method_25346() {
        class_5250 label = this.prefix.method_27661().method_27693(": ");
        class_5250 message = null;

        if (this.textMapper != null) {
            class_2561 mappedText = textMapper.getText(this.mappedValue);
            if (mappedText != null) {
                message = label.method_10852(mappedText);
            }
        }

        if (message == null) {
            String formatted = String.format(step % 1 == 0 ? "%.0f" : "%.2f", this.mappedValue);
            message = label.method_27693(formatted);
            if (this.suffix != null) {
                message.method_10852(this.suffix);
            }
        }

        this.method_25355(message);
    }

    @Override
    public void method_25348(class_11909 mouseButtonEvent, boolean doubleClick) {
        super.method_25348(mouseButtonEvent, doubleClick);
        this.sendMouseEvent(MouseEvent.CLICK);
    }

    @Override
    protected void method_25349(class_11909 mouseButtonEvent, double dragX, double dragY) {
        super.method_25349(mouseButtonEvent, dragX, dragY);
        this.sendMouseEvent(MouseEvent.DRAG);
    }

    @Override
    public void method_25357(class_11909 mouseButtonEvent) {
        super.method_25357(mouseButtonEvent);
        this.method_25365(false);
        this.sendMouseEvent(MouseEvent.RELEASE);
    }

    private void sendMouseEvent(MouseEvent mouseEvent) {
        if (this.mouseEventListener != null) {
            this.mouseEventListener.onMouseEvent(this, mouseEvent, this.mappedValue);
        }
    }

    @Override
    protected void method_25344() {
        this.mapValue();

        if (this.previousAppliedValue != this.mappedValue) {
            this.previousAppliedValue = this.mappedValue;
            this.listener.accept(this.mappedValue);
        }
    }

    private double unmapValue(double mappedValue) {
        double clampedValue = Math.max(min, Math.min(mappedValue, max));
        return (clampedValue - min) / (max - min);
    }

    private void mapValue() {
        double scaledValue = this.min + (this.field_22753 * (this.max - this.min));
        this.mappedValue = Math.round(scaledValue / this.step) * this.step;
    }

    public double getMappedValue() {
        return this.mappedValue;
    }

    public void applyMappedValue(double translatedValue) {
        this.field_22753 = this.unmapValue(translatedValue);
        this.method_25344();
        this.method_25346();
    }

    public class_2561 getPrefix() {
        return this.prefix;
    }

    @FunctionalInterface
    public interface MouseEventListener {
        void onMouseEvent(@NotNull SliderWidget target, @NotNull MouseEvent mouseEvent, double mappedValue);
    }

    @FunctionalInterface
    public interface TextMapper {
        @Nullable class_2561 getText(double mappedValue);
    }
}
