package io.github.fishstiz.cursors_extended.mixin.cursorprovider.menus;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import net.minecraft.class_11876;
import net.minecraft.class_1718;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_486;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Slice;

@Mixin(class_486.class)
public abstract class EnchantmentScreenMixin extends AbstractContainerScreenMixin<class_1718> {
    @Shadow @Final private static class_2960 ENCHANTMENT_SLOT_HIGHLIGHTED_SPRITE;

    protected EnchantmentScreenMixin(class_2561 title) {
        super(title);
    }

    @WrapOperation(
            method = "renderBg",
            slice = @Slice(from = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/gui/GuiGraphics;drawWordWrap(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/FormattedText;IIIIZ)V"
            )),
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIII)V"
            )
    )
    private void setPointerOnHighlight(class_332 instance, RenderPipeline renderPipeline, class_2960 resourceLocation, int x, int y, int width, int height, Operation<Void> original) {
        original.call(instance, renderPipeline, resourceLocation, x, y, width, height);
        if (CursorsExtended.CONFIG.isEnchantmentsEnabled() && resourceLocation == ENCHANTMENT_SLOT_HIGHLIGHTED_SPRITE) {
            instance.method_74037(class_11876.field_62455);
        }
    }
}
