package io.github.fishstiz.cursors_extended.resource.texture;

import io.github.fishstiz.cursors_extended.config.CursorProperties;
import io.github.fishstiz.cursors_extended.util.NativeImageUtil;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.MemoryUtil;

import java.io.IOException;
import net.minecraft.class_1011;

public abstract class AbstractCursorTexture implements CursorTexture {
    private long handle;

    protected AbstractCursorTexture(class_1011 image, CursorProperties settings) throws IOException {
        this.handle = NativeImageUtil.createCursor(image, settings);
    }

    @Override
    public long handle() {
        return handle;
    }

    @Override
    public void close() {
        if (handle != MemoryUtil.NULL) {
            GLFW.glfwDestroyCursor(handle);
            handle = MemoryUtil.NULL;
        }
    }
}
