package io.github.fishstiz.cursors_extended.util;

import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.gui.renderstate.GuiColoredRectRenderState;
import io.github.fishstiz.cursors_extended.platform.Services;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.joml.Matrix3x2f;

public class DrawUtil {
    private DrawUtil() {
    }

    public static void drawScrollableTextLeftAlign(
            class_332 context,
            class_327 textRenderer,
            class_2561 text,
            int startX,
            int startY,
            int endX,
            int endY,
            int color,
            boolean shadow
    ) {
        int textWidth = textRenderer.method_27525(text);
        int textY = (startY + endY - 9) / 2 + 1;
        int availableWidth = endX - startX;

        if (textWidth > availableWidth) {
            int overflowWidth = textWidth - availableWidth;
            double timeSeconds = class_156.method_658() / 1000.0;
            double scrollDuration = Math.max(overflowWidth * 0.5, 3.0);
            double scrollFactor = Math.sin((Math.PI / 2) * Math.cos((Math.PI * 2) * timeSeconds / scrollDuration)) / 2.0 + 0.5;
            double scrollOffset = class_3532.method_16436(scrollFactor, 0.0, overflowWidth);

            context.method_44379(startX, startY, endX, endY);
            context.method_51439(textRenderer, text, startX - (int) scrollOffset, textY, color, shadow);
            context.method_44380();
        } else {
            context.method_51439(textRenderer, text, startX, textY, color, shadow);
        }
    }

    public static void drawScrollableTextLeftAlign(
            class_332 context,
            class_327 textRenderer,
            class_2561 text,
            int startX,
            int startY,
            int endX,
            int endY,
            int color
    ) {
        drawScrollableTextLeftAlign(context, textRenderer, text, startX, startY, endX, endY, color, true);
    }

    public static void drawCheckerboard(
            class_332 guiGraphics,
            int x,
            int y,
            int width,
            int height,
            float cellWidth,
            float cellHeight,
            class_2960 checkerboard,
            int textureSize
    ) {
        float drawWidth = textureSize * cellWidth;
        float drawHeight = textureSize * cellHeight;

        float clippedWidth = Math.min(drawWidth, width);
        float clippedHeight = Math.min(drawHeight, height);

        float uRatio = clippedWidth / drawWidth;
        float vRatio = clippedHeight / drawHeight;

        int uvWidth = Math.round(textureSize * uRatio);
        int uvHeight = Math.round(textureSize * vRatio);

        guiGraphics.method_25302(
                class_10799.field_56883,
                checkerboard,
                x, y,
                0, 0,
                (int) clippedWidth, (int) clippedHeight,
                uvWidth, uvHeight,
                textureSize, textureSize
        );
    }

    public static void renderOutline(class_332 guiGraphics, int x, int y, int width, int height, int color) {
        guiGraphics.method_25294(x, y, x + width, y + 1, color);
        guiGraphics.method_25294(x, y + height - 1, x + width, y + height, color);
        guiGraphics.method_25294(x, y + 1, x + 1, y + height - 1, color);
        guiGraphics.method_25294(x + width - 1, y + 1, x + width, y + height - 1, color);
    }

    public static void fill(class_332 guiGraphics, float minX, float minY, float maxX, float maxY, int color) {
        Services.PLATFORM.guiGraphicsHelper().submitGuiElementRenderState(
                guiGraphics,
                new GuiColoredRectRenderState(new Matrix3x2f(guiGraphics.method_51448()), minX, minY, maxX, maxY, color)
        );
    }

    public static void drawCursor(class_332 guiGraphics, Cursor cursor, int x, int y, int size) {
        CursorTexture texture = cursor.getTexture();
        if (texture != null) {
            int spriteWidth = texture.spriteWidth();
            int spriteHeight = texture.spriteHeight();

            float scale = (float) size / Math.max(spriteWidth, spriteHeight);
            int drawWidth = Math.round(spriteWidth * scale);
            int drawHeight = Math.round(spriteHeight * scale);

            guiGraphics.method_25302(
                    class_10799.field_56883,
                    texture.comp_3627(),
                    x, y,
                    0, texture.spriteVOffset(),
                    drawWidth, drawHeight,
                    spriteWidth, spriteHeight,
                    texture.textureWidth(),
                    texture.textureHeight()
            );
        }
    }
}
