/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.compat.glfw;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Set;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;

public class GLFWInternal {
    private static final ThreadLocal<Boolean> INTERNAL_CALL = new ThreadLocal();
    private static final Set<Long> IMAGES = new LongOpenHashSet();

    private GLFWInternal() {
    }

    public static boolean isInternalCall() {
        return Boolean.TRUE.equals(INTERNAL_CALL.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean consumeInternalImage(long image) {
        Set<Long> set = IMAGES;
        synchronized (set) {
            return IMAGES.remove(image);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void trackInternalImage(long image) {
        Set<Long> set = IMAGES;
        synchronized (set) {
            IMAGES.add(image);
        }
    }

    public static long createStandardCursor(int shape) {
        try {
            INTERNAL_CALL.set(true);
            long l = GLFW.glfwCreateStandardCursor((int)shape);
            return l;
        }
        finally {
            INTERNAL_CALL.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long createCursor(GLFWImage glfwImage, int xhot, int yhot) {
        try {
            INTERNAL_CALL.set(true);
            long l = GLFW.nglfwCreateCursor((long)glfwImage.address(), (int)xhot, (int)yhot);
            return l;
        }
        finally {
            INTERNAL_CALL.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCursor(long window, long cursor) {
        try {
            INTERNAL_CALL.set(true);
            GLFW.glfwSetCursor((long)window, (long)cursor);
        }
        finally {
            INTERNAL_CALL.remove();
        }
    }
}

