/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.widget;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.gui.MouseEvent;
import io.github.fishstiz.cursors_extended.gui.widget.CursorWidget;
import io.github.fishstiz.cursors_extended.gui.widget.SliderWidget;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import java.util.Objects;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursorHotspotWidget
extends CursorWidget {
    private static final class_2960 BACKGROUND_128 = CursorsExtended.loc("textures/gui/background_128.png");
    private static final int BACKGROUND_DISABLED = -1358954496;
    private static final int RULER_COLOR = -65536;
    private static final int OVERRIDE_RULER_COLOR = -16711936;
    private static final class_2561 OVERFLOW_TEXT = class_2561.method_43471((String)"cursors_extended.options.image_too_large");
    private static final int OVERFLOW_COLOR = -1;
    private final SliderWidget xhotSlider;
    private final SliderWidget yhotSlider;
    @Nullable
    private final MouseEventListener mouseEventListener;
    private final int maxXHot;
    private final int maxYHot;
    private boolean dragging = false;

    public CursorHotspotWidget(@NotNull Cursor cursor, @NotNull SliderWidget xhotSlider, @NotNull SliderWidget yhotSlider, @Nullable MouseEventListener mouseEventListener) {
        super(class_5244.field_39003, cursor, BACKGROUND_128);
        this.xhotSlider = xhotSlider;
        this.yhotSlider = yhotSlider;
        this.mouseEventListener = mouseEventListener;
        this.maxXHot = SettingsUtil.getMaxXHot(cursor);
        this.maxYHot = SettingsUtil.getMaxYHot(cursor);
    }

    @Override
    protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.field_22763 = !this.isOverflowing() && (this.xhotSlider.method_37303() || this.yhotSlider.method_37303());
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        if (this.method_49606() && this.isOverflowing()) {
            class_327 font = class_310.method_1551().field_1772;
            int textX = this.method_46426() + (this.method_25368() / 2 - font.method_27525((class_5348)OVERFLOW_TEXT) / 2);
            int n = this.method_46427();
            int n2 = this.method_25364() / 2;
            Objects.requireNonNull(font);
            int textY = n + (n2 - 9 / 2);
            guiGraphics.method_27535(font, OVERFLOW_TEXT, textX, textY, -1);
        }
    }

    @Override
    protected void renderBackground(@NotNull class_332 guiGraphics) {
        super.renderBackground(guiGraphics);
        if (!this.field_22763) {
            guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), -1358954496);
        }
    }

    @Override
    protected void renderCursor(@NotNull class_332 guiGraphics, @NotNull Cursor cursor) {
        DrawUtil.drawCursor(guiGraphics, cursor, this.method_46426(), this.method_46427(), this.method_25368());
    }

    @Override
    protected void renderRuler(@NotNull class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.isOverflowing()) {
            return;
        }
        boolean isGlobalX = CursorsExtended.CONFIG.getGlobal().isXHotActive();
        boolean isGlobalY = CursorsExtended.CONFIG.getGlobal().isYHotActive();
        int colorX = isGlobalX ? -16711936 : -65536;
        int colorY = isGlobalY ? -16711936 : -65536;
        int xhot = this.clampHotspot(isGlobalX ? CursorsExtended.CONFIG.getGlobal().xhot() : (int)this.xhotSlider.getMappedValue(), this.maxXHot);
        int yhot = this.clampHotspot(isGlobalY ? CursorsExtended.CONFIG.getGlobal().yhot() : (int)this.yhotSlider.getMappedValue(), this.maxYHot);
        float rulerWidth = this.getCellWidth();
        float rulerHeight = this.getCellHeight();
        float xhotX1 = (float)this.method_46426() + (float)xhot * rulerWidth - (float)(!(rulerWidth > 1.0f) && xhot == this.maxXHot ? 1 : 0);
        float xhotX2 = (float)this.method_46426() + (float)xhot * rulerWidth + (xhot > 0 ? rulerWidth : Math.max(rulerWidth, 2.0f));
        float yhotY1 = (float)this.method_46427() + (float)yhot * rulerHeight - (float)(!(rulerHeight > 1.0f) && yhot == this.maxYHot ? 1 : 0);
        float yhotY2 = (float)this.method_46427() + (float)yhot * rulerHeight + (yhot > 0 ? rulerHeight : Math.max(rulerHeight, 2.0f));
        if (isGlobalX && !isGlobalY || isGlobalX == isGlobalY) {
            DrawUtil.fill(guiGraphics, this.method_46426(), yhotY1, this.method_55442(), yhotY2, colorY);
            DrawUtil.fill(guiGraphics, xhotX1, this.method_46427(), xhotX2, this.method_55443(), colorX);
        } else {
            DrawUtil.fill(guiGraphics, xhotX1, this.method_46427(), xhotX2, this.method_55443(), colorX);
            DrawUtil.fill(guiGraphics, this.method_46426(), yhotY1, this.method_55442(), yhotY2, colorY);
        }
    }

    public void method_25348(class_11909 mouseButtonEvent, boolean doubleClick) {
        this.dragging = true;
        this.setHotspots(MouseEvent.CLICK, mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799());
    }

    protected void method_25349(class_11909 mouseButtonEvent, double deltaX, double deltaY) {
        if (this.dragging) {
            this.setHotspots(MouseEvent.DRAG, mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799());
        }
    }

    public void method_25357(class_11909 mouseButtonEvent) {
        if (this.dragging) {
            this.dragging = false;
            this.setHotspots(MouseEvent.RELEASE, mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799());
            this.method_25365(false);
        }
    }

    public void setHotspots(MouseEvent mouseEvent, double mouseX, double mouseY) {
        int xhot = this.clampHotspot((int)((mouseX - (double)this.method_46426()) / (double)this.getCellWidth()), this.maxXHot);
        int yhot = this.clampHotspot((int)((mouseY - (double)this.method_46427()) / (double)this.getCellHeight()), this.maxYHot);
        if (this.xhotSlider.method_37303()) {
            this.xhotSlider.applyMappedValue(xhot);
        }
        if (this.yhotSlider.method_37303()) {
            this.yhotSlider.applyMappedValue(yhot);
        }
        if (this.mouseEventListener != null) {
            this.mouseEventListener.onMouseEvent(this, mouseEvent, xhot, yhot);
        }
    }

    private int clampHotspot(int hotspot, int max) {
        return SettingsUtil.clamp(hotspot, 0, max);
    }

    @Override
    public class_11875 cursors_extended$cursorType(double mouseX, double mouseY) {
        boolean inYHot;
        if (!this.field_22763) {
            return this.method_49606() ? class_11876.field_62459 : class_11875.field_62449;
        }
        if (!this.dragging) {
            return this.method_49606() ? class_11876.field_62454 : class_11875.field_62449;
        }
        boolean inXHot = !CursorsExtended.CONFIG.getGlobal().isXHotActive() && this.isInsideXHot(mouseX);
        boolean bl = inYHot = !CursorsExtended.CONFIG.getGlobal().isYHotActive() && this.isInsideYHot(mouseY);
        if (inXHot && inYHot) {
            return class_11876.field_62458;
        }
        if (inXHot) {
            return class_11876.field_62457;
        }
        if (inYHot) {
            return class_11876.field_62456;
        }
        return class_11876.field_62459;
    }

    private boolean isInsideXHot(double mouseX) {
        double rawX = (mouseX - (double)this.method_46426()) / (double)this.getCellWidth();
        return rawX >= 0.0 && rawX <= (double)this.maxXHot;
    }

    private boolean isInsideYHot(double mouseY) {
        double rawY = (mouseY - (double)this.method_46427()) / (double)this.getCellHeight();
        return rawY >= 0.0 && rawY <= (double)this.maxYHot;
    }

    public static interface MouseEventListener {
        public void onMouseEvent(@NotNull CursorHotspotWidget var1, @NotNull MouseEvent var2, int var3, int var4);
    }
}

