/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.gui.widget;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.gui.widget.CursorWidget;
import io.github.fishstiz.cursors_extended.resource.texture.AnimatedCursorTexture;
import io.github.fishstiz.cursors_extended.resource.texture.CursorTexture;
import io.github.fishstiz.cursors_extended.util.DrawUtil;
import java.util.Objects;
import net.minecraft.class_11875;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CursorPreviewWidget
extends CursorWidget {
    private static final class_2960 BACKGROUND_128 = CursorsExtended.loc("textures/gui/background_dark_128.png");
    private static final class_2561 PREVIEW_TEXT = class_2561.method_43471((String)"cursors_extended.options.preview");
    private static final int PREVIEW_TEXT_OFFSET = 4;
    private static final int PREVIEW_TEXT_COLOR = Integer.MAX_VALUE;
    private static final int RULER_COLOR = -16711936;
    private static final int BACKGROUND_DISABLED = 0x7F000000;
    private static final int BACKGROUND_OVERFLOW = -9803158;
    private static final int DEFAULT_BUTTON_SIZE = 20;
    @Nullable
    private final class_4185 button;
    private final class_327 font;

    public CursorPreviewWidget(@NotNull Cursor cursor, @NotNull class_327 font, @Nullable class_4185 button) {
        super(class_5244.field_39003, cursor, BACKGROUND_128);
        this.field_22763 = false;
        this.font = font;
        this.button = button;
    }

    public CursorPreviewWidget(@NotNull Cursor cursor, @NotNull class_327 font) {
        this(cursor, font, class_4185.method_46430((class_2561)class_5244.field_39003, b -> b.method_25365(false)).method_46437(20, 20).method_46431());
    }

    @Override
    protected void renderBackground(@NotNull class_332 guiGraphics) {
        super.renderBackground(guiGraphics);
        if (this.isOverflowing()) {
            guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), -9803158);
        }
    }

    @Override
    protected void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        Cursor cursor = this.getCursor();
        if (cursor.hasTexture()) {
            this.renderBackground(guiGraphics);
            if (cursor.isTextureEnabled()) {
                this.renderPreviewText(guiGraphics);
                this.renderTestButton(guiGraphics, mouseX, mouseY, partialTick);
                this.renderRuler(guiGraphics, mouseX, mouseY);
            }
        }
        if (!cursor.isTextureEnabled()) {
            guiGraphics.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), 0x7F000000);
        }
        this.renderBorder(guiGraphics);
        if (this.method_49606()) {
            guiGraphics.method_74037(this.cursors_extended$cursorType(mouseX, mouseY));
        }
    }

    protected void renderPreviewText(@NotNull class_332 guiGraphics) {
        int width = this.font.method_27525((class_5348)PREVIEW_TEXT);
        int endX = this.method_55442() - 4;
        int endY = this.method_55443() - 4;
        int startX = endX - width;
        Objects.requireNonNull(this.font);
        int startY = endY - 9;
        DrawUtil.drawScrollableTextLeftAlign(guiGraphics, this.font, PREVIEW_TEXT, startX, startY, endX, endY, Integer.MAX_VALUE, false);
    }

    protected void renderTestButton(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.button != null) {
            int buttonX = this.method_46426() + (this.method_25368() / 2 - this.button.method_25368() / 2);
            int buttonY = this.method_46427() + (this.method_25364() / 2 - this.button.method_25364() / 2);
            this.button.method_48229(buttonX, buttonY);
            this.button.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    @Override
    protected void renderRuler(@NotNull class_332 guiGraphics, int mouseX, int mouseY) {
        if (this.isRenderRuler() && this.method_25405(mouseX, mouseY)) {
            guiGraphics.method_51738(this.method_46426(), this.method_55442() - 1, mouseY, -16711936);
            guiGraphics.method_51742(mouseX, this.method_46427(), this.method_55443(), -16711936);
        }
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClicked) {
        CursorTexture cursorTexture;
        if (this.button != null && this.button.method_25405(mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799()) && this.button.method_25402(mouseButtonEvent, doubleClicked) && (cursorTexture = this.getCursor().getTexture()) instanceof AnimatedCursorTexture) {
            AnimatedCursorTexture animatedCursorTexture = (AnimatedCursorTexture)cursorTexture;
            animatedCursorTexture.restartAnimation();
        }
        return false;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764 && mouseX >= (double)this.method_46426() && mouseY >= (double)this.method_46427() && mouseX < (double)this.method_55442() && mouseY < (double)this.method_55443();
    }

    @Override
    protected float getCellWidth() {
        return this.method_25364() != this.method_25368() ? Math.max(super.getCellHeight(), super.getCellWidth()) : super.getCellWidth();
    }

    @Override
    protected float getCellHeight() {
        return this.method_25364() != this.method_25368() ? Math.max(super.getCellHeight(), super.getCellWidth()) : super.getCellHeight();
    }

    @Override
    public class_11875 cursors_extended$cursorType(double mouseX, double mouseY) {
        return this.getCursor().cursorType();
    }
}

