/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.util;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import io.github.fishstiz.cursors_extended.cursor.CursorTypesExt;
import java.util.Objects;
import net.minecraft.class_1041;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import net.minecraft.class_310;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;

public class CursorTypeUtil {
    private static final class_1041 WINDOW = class_310.method_1551().method_22683();

    private CursorTypeUtil() {
    }

    public static boolean nameEquals(class_11875 a, class_11875 b) {
        return Objects.equals(a.toString(), b.toString());
    }

    public static boolean canShift() {
        Cursor shiftCursor = CursorsExtended.getInstance().getRegistry().get(CursorTypesExt.SHIFT);
        return shiftCursor.isEnabled() && CursorsExtended.CONFIG.getOrCreateSettings(shiftCursor).enabled() && (class_3675.method_15987((class_1041)WINDOW, (int)340) || class_3675.method_15987((class_1041)WINDOW, (int)344));
    }

    public static boolean isLeftClickHeld() {
        return GLFW.glfwGetMouseButton((long)WINDOW.method_4490(), (int)0) == 1;
    }

    public static boolean isHeld(class_11875 lastCursorType) {
        return CursorTypesExt.isHoldType(lastCursorType) && CursorsExtended.getInstance().getRegistry().get(lastCursorType).isEnabled() && CursorTypeUtil.isLeftClickHeld();
    }

    public static boolean nonDefault(class_11875 cursorType) {
        return cursorType != null && !CursorTypeUtil.nameEquals(cursorType, class_11875.field_62449);
    }

    public static class_11875 arrowIfDefault(class_11875 cursorType) {
        return CursorTypeUtil.nameEquals(cursorType, class_11875.field_62449) ? class_11876.field_62452 : cursorType;
    }

    public static boolean isHovered(class_364 guiEventListener, double mouseX, double mouseY) {
        if (guiEventListener instanceof class_339) {
            class_339 widget = (class_339)guiEventListener;
            return widget.field_22764 && widget.method_49606() && mouseX >= (double)widget.method_46426() && mouseY >= (double)widget.method_46427() && mouseX < (double)widget.method_55442() && mouseY < (double)widget.method_55443();
        }
        return guiEventListener.method_25405(mouseX, mouseY);
    }

    @Nullable
    public static class_11875 mapStandardCursor(int shape) {
        return switch (shape) {
            case 221185 -> class_11875.field_62449;
            case 221188 -> class_11876.field_62455;
            case 221186 -> class_11876.field_62453;
            case 221187 -> class_11876.field_62454;
            case 221189 -> class_11876.field_62457;
            case 221190 -> class_11876.field_62456;
            case 221191 -> CursorTypesExt.RESIZE_NWSE;
            case 221192 -> CursorTypesExt.RESIZE_NESW;
            case 221193 -> class_11876.field_62458;
            case 221194 -> class_11876.field_62459;
            default -> null;
        };
    }

    @Nullable
    public static String mapStandardCursorName(int shape) {
        return switch (shape) {
            case 221185 -> "default";
            case 221188 -> "pointing_hand";
            case 221186 -> "ibeam";
            case 221187 -> "crosshair";
            case 221189 -> "resize_ew";
            case 221190 -> "resize_ns";
            case 221191 -> "resize_nwse";
            case 221192 -> "resize_nesw";
            case 221193 -> "resize_all";
            case 221194 -> "not_allowed";
            default -> null;
        };
    }
}

