/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.util;

import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.config.CursorProperties;
import io.github.fishstiz.cursors_extended.cursor.Cursor;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_7172;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SettingsUtil {
    public static final int IMAGE_SIZE_MIN = 8;
    public static final int IMAGE_SIZE_GUI_MAX = 128;
    public static final float SCALE_AUTO_PREFERRED = 0.0f;
    public static final float SCALE_AUTO_THRESHOLD_MAX = 0.49f;
    public static final float SCALE = 1.0f;
    public static final float SCALE_MIN = 0.0f;
    public static final float SCALE_MAX = 8.0f;
    public static final float SCALE_STEP = 0.05f;
    public static final int X_HOT = 0;
    public static final int Y_HOT = 0;
    public static final int HOT_MIN = 0;
    public static final int HOT_STEP = 1;
    public static final boolean ENABLED = true;
    public static final Boolean ANIMATED = null;

    private SettingsUtil() {
    }

    public static void assertImageSize(int imageWidth, int imageHeight) throws IOException {
        if (imageWidth < 8 || imageHeight < 8) {
            throw new IOException("Image width/height cannot be less than 8");
        }
    }

    public static boolean isAutoScale(float scale) {
        return scale <= 0.49f;
    }

    public static boolean isAutoScale(double scale) {
        return SettingsUtil.isAutoScale((float)scale);
    }

    @Nullable
    public static class_2561 getAutoText(float scale) {
        return SettingsUtil.isAutoScale(scale) ? class_2561.method_43471((String)"options.guiScale.auto") : null;
    }

    @Nullable
    public static class_2561 getAutoText(double scale) {
        return SettingsUtil.getAutoText((float)scale);
    }

    public static float getAutoScale(float scale) {
        if (SettingsUtil.isAutoScale(scale)) {
            class_7172 guiScale = class_310.method_1551().field_1690.method_42474();
            int max = Integer.MAX_VALUE;
            int guiScaleValue = (Integer)guiScale.method_41753();
            class_7172.class_7178 class_71782 = guiScale.method_41754();
            if (class_71782 instanceof class_7172.class_7304) {
                class_7172.class_7304 range = (class_7172.class_7304)class_71782;
                max = range.comp_594();
            }
            return guiScaleValue != 0 ? (float)Math.min(max, guiScaleValue) : (float)class_310.method_1551().method_22683().method_4495();
        }
        return scale;
    }

    public static float sanitizeScale(float scale) {
        double clampedScale = SettingsUtil.clamp(scale, 0.0, 8.0);
        double mappedScale = (float)Math.round(clampedScale / (double)0.05f) * 0.05f;
        if (SettingsUtil.isAutoScale(mappedScale)) {
            return 0.0f;
        }
        return (float)Math.round(mappedScale * 100.0) / 100.0f;
    }

    public static int sanitizeHotspot(int hotspot, int imageSize) {
        return SettingsUtil.clamp(hotspot, 0, imageSize - 1);
    }

    public static int sanitizeXHot(int xhot, @NotNull Cursor cursor) {
        return SettingsUtil.sanitizeHotspot(xhot, cursor.getTexture() != null ? cursor.getTexture().spriteWidth() : 0);
    }

    public static int sanitizeYHot(int yhot, @NotNull Cursor cursor) {
        return SettingsUtil.sanitizeHotspot(yhot, cursor.getTexture() != null ? cursor.getTexture().spriteHeight() : 0);
    }

    public static double clamp(double value, double min, double max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int clamp(int value, int min, int max) {
        return Math.max(min, Math.min(max, value));
    }

    public static int getMaxXHot(Cursor cursor) {
        if (cursor != null && cursor.getTexture() != null) {
            return cursor.getTexture().spriteWidth() - 1;
        }
        return 0;
    }

    public static int getMaxYHot(Cursor cursor) {
        if (cursor != null && cursor.getTexture() != null) {
            return cursor.getTexture().spriteHeight() - 1;
        }
        return 0;
    }

    public static boolean equalSettings(@Nullable CursorProperties a, @Nullable CursorProperties b, boolean excludeGlobal) {
        if (Objects.equals(a, b)) {
            return true;
        }
        if (a != null && b != null) {
            boolean equal;
            boolean bl = equal = a.enabled() == b.enabled() && Objects.equals(a.animated(), b.animated());
            if (!excludeGlobal || !CursorsExtended.CONFIG.getGlobal().isXHotActive()) {
                equal &= a.xhot() == b.xhot();
            }
            if (!excludeGlobal || !CursorsExtended.CONFIG.getGlobal().isYHotActive()) {
                equal &= a.yhot() == b.yhot();
            }
            if (!excludeGlobal || !CursorsExtended.CONFIG.getGlobal().isScaleActive()) {
                equal &= Float.compare(a.scale(), b.scale()) == 0;
            }
            return equal;
        }
        return false;
    }
}

