/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.gui.widget.ElementView;
import io.github.fishstiz.minecraftcursor.util.SettingsUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractListWidget<E extends Entry>
extends ContainerObjectSelectionList<E> {
    public static final int DEFAULT_HEADER_HEIGHT = -4;
    protected final int rowGap;

    protected AbstractListWidget(Minecraft minecraft, int width, int y, int height, int itemHeight) {
        super(minecraft, width, y, height, itemHeight, -4);
        this.rowGap = 0;
    }

    protected AbstractListWidget(Minecraft minecraft, int width, int y, int height, int itemHeight, int rowGap) {
        super(minecraft, width, y, height, itemHeight + rowGap, -4);
        this.rowGap = rowGap;
    }

    protected void renderListItems(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int left = this.getRowLeft();
        int width = this.getRowWidth();
        for (int i = 0; i < this.getItemCount(); ++i) {
            int top = this.getRowTop(i);
            int bottom = this.getRowBottom(i);
            if (bottom < this.getY() || top > this.getBottom()) continue;
            this.renderItem(guiGraphics, mouseX, mouseY, partialTick, i, left, top, width, this.itemHeight);
        }
    }

    public int maxScrollAmount() {
        return Math.max(0, super.maxScrollAmount() - this.rowGap);
    }

    public void setClampedScrollAmount(double scrollAmount) {
        this.setScrollAmount(SettingsUtil.clamp(scrollAmount, 0.0, (double)this.maxScrollAmount()));
    }

    public void clampScrollAmount() {
        this.setClampedScrollAmount(this.scrollAmount());
    }

    protected int scrollBarX() {
        return this.getRight() - 6;
    }

    public int getRowWidth() {
        return this.scrollbarVisible() ? this.getWidth() - 6 : this.getWidth();
    }

    public int getRowLeft() {
        return this.getX();
    }

    public void setHeight(int height) {
        super.setHeight(height);
        this.clampScrollAmount();
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.clampScrollAmount();
    }

    protected abstract class Entry
    extends ContainerObjectSelectionList.Entry<E>
    implements ElementView {
        private final int index;

        protected Entry(int index) {
            this.index = index;
        }

        protected Entry() {
            this(this$0.children().size());
        }

        @Override
        public int getX() {
            return AbstractListWidget.this.getRowLeft();
        }

        @Override
        public int getY() {
            return AbstractListWidget.this.getRowTop(this.index);
        }

        @Override
        public int getWidth() {
            return AbstractListWidget.this.getRowWidth();
        }

        @Override
        public int getHeight() {
            return AbstractListWidget.this.itemHeight - AbstractListWidget.this.rowGap;
        }

        @Override
        @NotNull
        public ScreenRectangle getRectangle() {
            return ElementView.super.getRectangle();
        }
    }
}

