package io.github.fishstiz.minecraftcursor.cursorhandler.ingame;

import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.mixin.access.*;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import net.minecraft.class_1729;
import net.minecraft.class_339;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_489;
import net.minecraft.class_490;
import net.minecraft.class_508;

public class RecipeBookScreenCursorHandler<T extends class_465<? extends class_1729<?, ?>>> extends HandledScreenCursorHandler<class_1729<?, ?>, T> {
    public static final RecipeBookScreenCursorHandler<class_490> INVENTORY = new RecipeBookScreenCursorHandler<>();
    public static final RecipeBookScreenCursorHandler<class_479> CRAFTING = new RecipeBookScreenCursorHandler<>();
    public static final RecipeBookScreenCursorHandler<class_489<?>> FURNACE = new RecipeBookScreenCursorHandler<>();

    private class_508 alternatesWidget;

    @Override
    public CursorType getCursorType(T recipeBookScreen, double mouseX, double mouseY) {
        CursorType cursorType = super.getCursorType(recipeBookScreen, mouseX, mouseY);
        if (cursorType != CursorType.DEFAULT && (alternatesWidget == null || !alternatesWidget.method_2616())) {
            return cursorType;
        }

        RecipeBookWidgetAccessor recipeBook = getRecipeBook(recipeBookScreen);
        if (recipeBook == null || !recipeBook.invokeIsOpen()) return CursorType.DEFAULT;

        RecipeBookResultsAccessor recipesArea = (RecipeBookResultsAccessor) recipeBook.getRecipesArea();
        alternatesWidget = recipesArea.getAlternatesWidget();

        if (alternatesWidget.method_2616()) {
            return getAlternatesWidgetCursor((RecipeAlternativesWidgetAccessor) alternatesWidget);
        }

        if (recipesArea.getHoveredResultButton() != null && CursorTypeUtil.canShift()) {
            return CursorType.SHIFT;
        } else if (isButtonHovered(recipeBook, recipesArea) || recipesArea.getHoveredResultButton() != null) {
            return CursorType.POINTER;
        } else if (recipeBook.getSearchField().method_49606()) {
            return CursorType.TEXT;
        }
        return getTabCursor(recipeBook);
    }

    private RecipeBookWidgetAccessor getRecipeBook(class_465<?> screen) {
        return switch (screen) {
            case InventoryScreen inventory ->
                    (RecipeBookWidgetAccessor) ((InventoryScreenAccessor) inventory).getRecipeBook();
            case CraftingScreen crafting ->
                    (RecipeBookWidgetAccessor) ((CraftingScreenAccessor) crafting).getRecipeBook();
            case AbstractFurnaceScreen<?> furnace ->
                    (RecipeBookWidgetAccessor) ((AbstractFurnaceScreenAccessor) furnace).getRecipeBook();
            default -> null;
        };
    }

    private CursorType getAlternatesWidgetCursor(RecipeAlternativesWidgetAccessor alternatesWidget) {
        return alternatesWidget.getAlternativeButtons().stream().anyMatch(class_339::method_49606)
                ? (CursorTypeUtil.canShift() ? CursorType.SHIFT : CursorType.POINTER)
                : CursorType.DEFAULT_FORCE;
    }

    private boolean isButtonHovered(RecipeBookWidgetAccessor recipeBook, RecipeBookResultsAccessor recipesArea) {
        return (recipesArea.getPrevPageButton().method_49606() && recipesArea.getPrevPageButton().field_22764) ||
                (recipesArea.getNextPageButton().method_49606() && recipesArea.getNextPageButton().field_22764) ||
                recipeBook.getToggleCraftableButton().method_49606();
    }

    private CursorType getTabCursor(RecipeBookWidgetAccessor recipeBook) {
        return recipeBook.getTabButtons().stream().anyMatch(btn -> btn.method_49606() && btn != recipeBook.getCurrentTab())
                ? CursorType.POINTER
                : CursorType.DEFAULT;
    }
}
