package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.gui.widget.MoreOptionsListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorHotspotWidget;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8132;
import org.jetbrains.annotations.Nullable;

public class MoreOptionsScreen extends class_437 implements CursorProvider {
    private static final int HOTSPOT_WIDGET_SIZE = 96;
    private final class_8132 layout = new class_8132(this);
    private final class_437 previousScreen;
    private final CursorManager cursorManager;
    private final @Nullable SelectedCursorHotspotWidget hotspotWidget;
    private final class_4185 doneButton = class_4185.method_46430(class_5244.field_24334, btn -> this.method_25419()).method_46431();
    private MoreOptionsListWidget list;

    protected MoreOptionsScreen(class_437 previousScreen, CursorManager cursorManager) {
        super(class_2561.method_43471("minecraft-cursor.options.more"));

        this.previousScreen = previousScreen;
        this.cursorManager = cursorManager;

        if (previousScreen instanceof CursorOptionsScreen optionsScreen && optionsScreen.body != null) {
            this.hotspotWidget = new SelectedCursorHotspotWidget(
                    HOTSPOT_WIDGET_SIZE,
                    optionsScreen.body.selectedCursorColumn
            );

            this.hotspotWidget.field_22764 = false;
            this.method_25429(this.hotspotWidget);
        } else {
            this.hotspotWidget = null;
        }
    }

    @Override
    protected void method_25426() {
        if (this.list != null && this.list.isReloaded()) {
            method_25419();
        }

        this.layout.method_57726(this.field_22785, this.field_22793);

        this.list = this.layout.method_48999(new MoreOptionsListWidget(
                this.field_22787, field_22789, layout.method_57727(), layout.method_48998(), cursorManager
        ));

        if (this.hotspotWidget != null) {
            this.hotspotWidget.setChangeEventListener(this.list::handleChangeHotspotWidget);
        }

        this.layout.method_48996(doneButton);

        this.layout.method_48206(this::method_37063);

        this.refreshWidgetPositions();
    }

    protected void refreshWidgetPositions() {
        if (this.list != null) {
            this.layout.method_48222();
            this.list.method_57712(field_22789, layout);
        }
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);

        if (list == null || hotspotWidget == null) return;

        if (list.isEditingHotspot()) {
            int rowGap = list.getRowGap();
            int x = list.method_25342() - hotspotWidget.method_25368() - rowGap;
            int y = list.getYEntry(1) + rowGap / 2;

            hotspotWidget.method_48229(x, y);
            hotspotWidget.field_22764 = true;
            hotspotWidget.field_22763 = true;

            context.method_44379(x, layout.method_48998(), list.method_25342(), layout.method_48998() + layout.method_57727());
            hotspotWidget.method_25394(context, mouseX, mouseY, delta);
            context.method_44380();
        } else {
            hotspotWidget.field_22764 = false;
            hotspotWidget.field_22763 = false;
        }
    }

    @Override
    public void method_25419() {
        list.applyConfig();

        if (this.field_22787 != null) {
            if (previousScreen instanceof CursorOptionsScreen options && options.body != null) {
                CursorOptionsScreen optionsScreen = new CursorOptionsScreen(options.previousScreen, cursorManager);
                optionsScreen.selectCursor(options.getSelectedCursor());
                this.field_22787.method_1507(optionsScreen);
            } else {
                this.field_22787.method_1507(previousScreen);
            }
        }
    }

    @Override
    public CursorType getCursorType(double mouseX, double mouseY) {
        int headerHeight = layout.method_48998();
        if ((mouseY < headerHeight || mouseY > headerHeight + layout.method_57727())
                && mouseX > doneButton.method_46426() + doneButton.method_25368()) {
            return CursorType.DEFAULT_FORCE;
        }
        return CursorType.DEFAULT;
    }
}
