package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.gui.screen.CursorOptionsScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_9017;

import static io.github.fishstiz.minecraftcursor.MinecraftCursor.CONFIG;
import static io.github.fishstiz.minecraftcursor.config.CursorConfig.Settings.Default.*;

public class CursorOptionsWidget extends class_9017 {
    private static final int OPTIONS_HEIGHT = 24;
    private static final int GRID_PADDING = 4;
    private static final int BOX_WIDGET_TEXTURE_SIZE = 96;
    private static final int HELPER_BUTTON_SIZE = 16;
    private static final int HELPER_ICON_SIZE = 10;
    private static final class_2960 HELPER_ICON = class_2960.method_60656("textures/gui/sprites/icon/unseen_notification.png");
    private static final String GLOBAL_TEXT_KEY = "minecraft-cursor.options.global.tooltip";
    private static final class_2561 ANIMATE_TEXT = class_2561.method_43471("minecraft-cursor.options.animate");
    private static final class_2561 RESET_ANIMATION_TEXT = class_2561.method_43471("minecraft-cursor.options.animate-reset");
    private static final String HOT_UNIT = "px";

    public static final class_2561 ENABLED_TEXT = class_2561.method_43471("minecraft-cursor.options.enabled");
    public static final class_2561 SCALE_TEXT = class_2561.method_43471("minecraft-cursor.options.scale");
    public static final class_2561 XHOT_TEXT = class_2561.method_43471("minecraft-cursor.options.xhot");
    public static final class_2561 YHOT_TEXT = class_2561.method_43471("minecraft-cursor.options.yhot");

    private final CursorOptionsScreen parent;
    private final CursorOptionsHandler handler;
    SelectedCursorToggleWidget enableButton;
    SelectedCursorSliderWidget scaleSlider;
    SelectedCursorSliderWidget xhotSlider;
    SelectedCursorSliderWidget yhotSlider;
    SelectedCursorToggleWidget animateButton;
    SelectedCursorButtonWidget resetAnimation;
    SelectedCursorHotspotWidget cursorHotspot;
    SelectedCursorTestWidget cursorTest;

    public CursorOptionsWidget(int x, int width, int height, int y,  CursorOptionsScreen optionsScreen) {
        super(x, y, width, height, class_2561.method_43473());

        this.parent = optionsScreen;
        this.handler = new CursorOptionsHandler(this);

        initWidgets();
    }

    private void initWidgets() {
        CursorConfig.Settings settings = handler.getSettings();

        enableButton = new SelectedCursorToggleWidget(ENABLED_TEXT, settings.isEnabled(), handler::handleEnable);
        scaleSlider = new SelectedCursorSliderWidget(
                SCALE_TEXT, settings.getScale(),
                SCALE_MIN, SCALE_MAX, SCALE_STEP,
                handler::handleChangeScale, CursorOptionsHandler::removeScaleOverride);
        bindHelperButton(scaleSlider);

        xhotSlider = createHotspotSlider(XHOT_TEXT, settings.getXHot(), handler::handleChangeXHot);
        yhotSlider = createHotspotSlider(YHOT_TEXT, settings.getYHot(), handler::handleChangeYHot);

        animateButton = new SelectedCursorToggleWidget(ANIMATE_TEXT, handler.isAnimated(), handler::handlePressAnimate);
        resetAnimation = new SelectedCursorButtonWidget(RESET_ANIMATION_TEXT, handler::handleResetAnimation);

        cursorHotspot = new SelectedCursorHotspotWidget(BOX_WIDGET_TEXTURE_SIZE, this);
        cursorHotspot.setChangeEventListener(handler::handleChangeHotspotWidget);

        cursorTest = new SelectedCursorTestWidget(BOX_WIDGET_TEXTURE_SIZE, this);

        refreshWidgets();
    }

    private SelectedCursorSliderWidget createHotspotSlider(class_2561 prefix, int value, DoubleConsumer onApply) {
        var slider = new SelectedCursorSliderWidget(
                prefix, value,
                HOT_MIN, HOT_MAX, 1, HOT_UNIT,
                handler.handleChangeHotspots(onApply)
        );
        bindHelperButton(slider);

        return slider;
    }

    private void bindHelperButton(SelectedCursorSliderWidget sliderWidget) {
        var helperButton = new SelectedCursorButtonWidget(HELPER_ICON, HELPER_ICON_SIZE, HELPER_ICON_SIZE, parent::toMoreOptions);
        helperButton.method_47400(class_7919.method_47407(class_2561.method_43469(GLOBAL_TEXT_KEY, sliderWidget.getPrefix())));
        sliderWidget.setInactiveHelperButton(helperButton, HELPER_BUTTON_SIZE, HELPER_BUTTON_SIZE);
    }

    private void refreshWidgets() {
        CursorConfig.GlobalSettings global = CONFIG.getGlobal();
        CursorConfig.Settings settings = handler.getSettings();

        enableButton.setValue(settings.isEnabled());
        scaleSlider.update(settings.getScale(), !global.isScaleActive());
        xhotSlider.update(settings.getXHot(), !global.isXHotActive());
        yhotSlider.update(settings.getYHot(), !global.isYHotActive());

        boolean isAnimated = handler.isAnimated();
        animateButton.field_22763 = handler.getCursorAsAnimatedCursor().isPresent();
        resetAnimation.field_22763 = isAnimated && enableButton.value;
        animateButton.setValue(isAnimated);

        cursorHotspot.setRulerRendered(true, true);
        cursorHotspot.field_22763 = !(global.isXHotActive() && global.isYHotActive());

        method_25396().forEach(widget -> widget.method_25365(false));
    }

    @Override
    public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        placeWidgets();

        enableButton.method_25394(context, mouseX, mouseY, delta);
        scaleSlider.method_48579(context, mouseX, mouseY, delta);
        xhotSlider.method_48579(context, mouseX, mouseY, delta);
        yhotSlider.method_48579(context, mouseX, mouseY, delta);

        if (handler.getCursorAsAnimatedCursor().isPresent()) {
            animateButton.method_25394(context, mouseX, mouseY, delta);
            resetAnimation.method_25394(context, mouseX, mouseY, delta);
        }

        cursorHotspot.method_48579(context, mouseX, mouseY, delta);
        cursorTest.method_48579(context, mouseX, mouseY, delta);
    }

    private void placeWidgets() {
        boolean isAnimatedCursor = handler.getCursorAsAnimatedCursor().isPresent();

        grid(enableButton, 0, 0);
        grid(scaleSlider, 1, 0);
        grid(xhotSlider, 0, 1);
        grid(yhotSlider, 1, 1);

        if (isAnimatedCursor) {
            grid(animateButton, 0, 2);
            grid(resetAnimation, 1, 2);
            grid(cursorHotspot, 0, 3, true);
            grid(cursorTest, 1, 3, true);
        } else {
            grid(cursorHotspot, 0, 2, true);
            grid(cursorTest, 1, 2, true);
        }
    }

    private void grid(class_339 widget, int gridX, int gridY) {
        grid(widget, gridX, gridY, false);
    }

    private void grid(class_339 widget, int gridX, int gridY, boolean absolute) {
        if (!absolute) {
            widget.method_25358((method_25368() / 2) - GRID_PADDING);
            widget.method_53533(OPTIONS_HEIGHT - GRID_PADDING);
        }
        widget.method_46421(method_46426() + ((method_25368() / 2) * gridX));
        widget.method_46419(method_46427() + (OPTIONS_HEIGHT * (gridY)));
    }

    public void save() {
        handler.updateSettings();
    }

    public void refresh() {
        refreshWidgets();
    }

    public CursorOptionsScreen parent() {
        return parent;
    }

    @Override
    public List<? extends class_364> method_25396() {
        List<class_364> children = new ArrayList<>(List.of(
                enableButton,
                scaleSlider,
                xhotSlider,
                yhotSlider,
                animateButton,
                resetAnimation,
                cursorHotspot,
                cursorTest
        ));

        addHelperButton(scaleSlider, children);
        addHelperButton(xhotSlider, children);
        addHelperButton(yhotSlider, children);

        return children;
    }

    private void addHelperButton(SelectedCursorSliderWidget slider, List<class_364> children) {
        if (slider != null) {
            var helperButton = slider.getInactiveHelperButton();
            if (helperButton != null) {
                children.add(helperButton);
            }
        }
    }

    @Override
    protected void method_47399(class_6382 builder) {
        // not supported
    }
}
