package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import io.github.fishstiz.minecraftcursor.util.MouseEvent;
import java.util.function.BiConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6382;

import static io.github.fishstiz.minecraftcursor.MinecraftCursor.CONFIG;

public class SelectedCursorHotspotWidget extends class_339 implements CursorProvider {
    private static final CursorConfig.GlobalSettings global = CONFIG.getGlobal();
    private static final class_2960 BACKGROUND = class_2960.method_60655(MinecraftCursor.MOD_ID, "textures/gui/hotspot_background.png");
    private static final int CURSOR_SIZE = 32;
    private static final int RULER_COLOR = 0xFFFF0000; // red
    private static final int OVERRIDE_RULER_COLOR = 0xFF00FF00; // green
    private final CursorOptionsWidget options;
    private boolean rulerRendered = true;
    private float rulerAlpha = 1f;
    private MouseEventListener changeEventListener;

    public SelectedCursorHotspotWidget(int size, CursorOptionsWidget options) {
        super(options.method_46426(), options.method_46427(), size, size, class_2561.method_43473());
        this.options = options;
    }

    @Override
    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25290(BACKGROUND, method_46426(), method_46427(), 0, 0, field_22758, field_22759, field_22758, field_22759);
        if (!field_22763) context.method_25294(method_46426(), method_46427(), method_55442(), method_55443(), 0xAF000000); // 70% black

        drawCursorTexture(context);
        renderRuler(context, mouseX, mouseY);
        context.method_49601(method_46426(), method_46427(), method_25368(), method_25364(), 0xFF000000);
    }

    private void drawCursorTexture(class_332 context) {
        options.parent().animationHelper.drawSprite(context, options.parent().getSelectedCursor(), method_46426(), method_46427(), field_22758);
    }

    private void renderRuler(class_332 context, int mouseX, int mouseY) {
        if (method_25405(mouseX, mouseY)) setRulerRendered(true, false);

        rulerAlpha = class_3532.method_16439(0.3f, rulerAlpha, rulerRendered ? 1f : 0f);

        if (rulerAlpha <= 0.01f) return;

        boolean isGlobalX = global.isXHotActive();
        boolean isGlobalY = global.isYHotActive();

        int xhot = isGlobalX ? global.getXHot() : (int) options.xhotSlider.getTranslatedValue();
        int yhot = isGlobalY ? global.getYHot() : (int) options.yhotSlider.getTranslatedValue();

        int rulerSize = getRulerSize();
        int xhotX1 = (method_46426() + xhot * rulerSize);
        int xhotX2 = (method_46426() + xhot * rulerSize) + rulerSize;
        int yhotY1 = (method_46427() + yhot * rulerSize);
        int yhotY2 = (method_46427() + yhot * rulerSize) + rulerSize;

        int alpha = (int) (rulerAlpha * 255);

        int blendedColorX = getBlendedColor(isGlobalX ? OVERRIDE_RULER_COLOR : RULER_COLOR, alpha);
        int blendedColorY = getBlendedColor(isGlobalY ? OVERRIDE_RULER_COLOR : RULER_COLOR, alpha);

        if ((isGlobalX && !isGlobalY) || (isGlobalX == isGlobalY)) {
            context.method_25294(method_46426(), yhotY1, method_55442(), yhotY2, blendedColorY);
            context.method_25294(xhotX1, method_46427(), xhotX2, method_55443(), blendedColorX);
        } else {
            context.method_25294(xhotX1, method_46427(), xhotX2, method_55443(), blendedColorX);
            context.method_25294(method_46426(), yhotY1, method_55442(), yhotY2, blendedColorY);
        }
    }

    public int getBlendedColor(int color, int alpha) {
        return (alpha << 24) | (color & 0x00FFFFFF);
    }

    @Override
    public void method_25348(double mouseX, double mouseY) {
        setHotspots(MouseEvent.CLICK, mouseX, mouseY);
    }

    @Override
    protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        setHotspots(MouseEvent.DRAG, mouseX, mouseY);
    }

    public void setHotspots(MouseEvent mouseEvent, double mouseX, double mouseY) {
        if (changeEventListener != null) {
            int rulerSize = getRulerSize();
            int x = ((int) mouseX - method_46426()) / rulerSize;
            int y = ((int) mouseY - method_46427()) / rulerSize;

            changeEventListener.onChange(mouseEvent, x, y);
        }

        setRulerRendered(true, true);
    }

    private int getRulerSize() {
        return method_25368() / CURSOR_SIZE;
    }

    public void setRulerRendered(boolean rulerRendered, boolean immediate) {
        if (immediate) rulerAlpha = rulerRendered ? 1f : 0f;
        this.rulerRendered = rulerRendered;
    }

    @Override
    public CursorType getCursorType(double mouseX, double mouseY) {
        if (!field_22763) {
            return CursorType.DEFAULT;
        }
        if (method_25370() && (CursorTypeUtil.isLeftClickHeld() || CursorTypeUtil.isGrabbing())) {
            return CursorType.GRABBING;
        }
        return CursorType.POINTER;
    }

    public void setChangeEventListener(BiConsumer<Integer, Integer> changeEventListener) {
        setChangeEventListener((mouseEvent, x, y) -> changeEventListener.accept(x, y));
    }

    public void setChangeEventListener(MouseEventListener changeEventListener) {
        this.changeEventListener = changeEventListener;
    }

    @Override
    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764
                && mouseX >= this.method_46426()
                && mouseY >= this.method_46427()
                && mouseX < this.method_55442()
                && mouseY < this.method_55443();
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (method_25370()) {
            setHotspots(MouseEvent.RELEASE, mouseX, mouseY);
        }

        return super.method_25406(mouseX, mouseY, button);
    }

    @Override
    protected void method_47399(class_6382 builder) {
        // not supported
    }

    @FunctionalInterface
    public interface MouseEventListener {
        void onChange(MouseEvent mouseEvent, int xhot, int yhot);
    }
}
