/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.cursorhandler.ingame;

import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.cursorhandler.ingame.HandledScreenCursorHandler;
import io.github.fishstiz.minecraftcursor.mixin.access.AbstractFurnaceScreenAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.CraftingScreenAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.InventoryScreenAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.RecipeAlternativesWidgetAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.RecipeBookResultsAccessor;
import io.github.fishstiz.minecraftcursor.mixin.access.RecipeBookWidgetAccessor;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_1729;
import net.minecraft.class_339;
import net.minecraft.class_465;
import net.minecraft.class_479;
import net.minecraft.class_489;
import net.minecraft.class_490;
import net.minecraft.class_508;

public class RecipeBookScreenCursorHandler<T extends class_465<? extends class_1729<?, ?>>>
extends HandledScreenCursorHandler<class_1729<?, ?>, T> {
    public static final RecipeBookScreenCursorHandler<class_490> INVENTORY = new RecipeBookScreenCursorHandler();
    public static final RecipeBookScreenCursorHandler<class_479> CRAFTING = new RecipeBookScreenCursorHandler();
    public static final RecipeBookScreenCursorHandler<class_489<?>> FURNACE = new RecipeBookScreenCursorHandler();
    private class_508 alternatesWidget;

    @Override
    public CursorType getCursorType(T recipeBookScreen, double mouseX, double mouseY) {
        CursorType cursorType = super.getCursorType(recipeBookScreen, mouseX, mouseY);
        if (!(cursorType == CursorType.DEFAULT || this.alternatesWidget != null && this.alternatesWidget.method_2616())) {
            return cursorType;
        }
        RecipeBookWidgetAccessor recipeBook = this.getRecipeBook((class_465<?>)recipeBookScreen);
        if (recipeBook == null || !recipeBook.invokeIsOpen()) {
            return CursorType.DEFAULT;
        }
        RecipeBookResultsAccessor recipesArea = (RecipeBookResultsAccessor)recipeBook.getRecipesArea();
        this.alternatesWidget = recipesArea.getAlternatesWidget();
        if (this.alternatesWidget.method_2616()) {
            return this.getAlternatesWidgetCursor((RecipeAlternativesWidgetAccessor)this.alternatesWidget);
        }
        if (recipesArea.getHoveredResultButton() != null && CursorTypeUtil.canShift()) {
            return CursorType.SHIFT;
        }
        if (this.isButtonHovered(recipeBook, recipesArea) || recipesArea.getHoveredResultButton() != null) {
            return CursorType.POINTER;
        }
        if (recipeBook.getSearchField().method_49606()) {
            return CursorType.TEXT;
        }
        return this.getTabCursor(recipeBook);
    }

    private RecipeBookWidgetAccessor getRecipeBook(class_465<?> screen) {
        class_465<?> class_4652 = screen;
        Objects.requireNonNull(class_4652);
        class_465<?> class_4653 = class_4652;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_490.class, class_479.class, class_489.class}, class_4653, n)) {
            case 0 -> {
                class_490 inventory = (class_490)class_4653;
                yield (RecipeBookWidgetAccessor)((InventoryScreenAccessor)inventory).getRecipeBook();
            }
            case 1 -> {
                class_479 crafting = (class_479)class_4653;
                yield (RecipeBookWidgetAccessor)((CraftingScreenAccessor)crafting).getRecipeBook();
            }
            case 2 -> {
                class_489 furnace = (class_489)class_4653;
                yield (RecipeBookWidgetAccessor)((AbstractFurnaceScreenAccessor)furnace).getRecipeBook();
            }
            default -> null;
        };
    }

    private CursorType getAlternatesWidgetCursor(RecipeAlternativesWidgetAccessor alternatesWidget) {
        return alternatesWidget.getAlternativeButtons().stream().anyMatch(class_339::method_49606) ? (CursorTypeUtil.canShift() ? CursorType.SHIFT : CursorType.POINTER) : CursorType.DEFAULT_FORCE;
    }

    private boolean isButtonHovered(RecipeBookWidgetAccessor recipeBook, RecipeBookResultsAccessor recipesArea) {
        return recipesArea.getPrevPageButton().method_49606() && recipesArea.getPrevPageButton().field_22764 || recipesArea.getNextPageButton().method_49606() && recipesArea.getNextPageButton().field_22764 || recipeBook.getToggleCraftableButton().method_49606();
    }

    private CursorType getTabCursor(RecipeBookWidgetAccessor recipeBook) {
        return recipeBook.getTabButtons().stream().anyMatch(btn -> btn.method_49606() && btn != recipeBook.getCurrentTab()) ? CursorType.POINTER : CursorType.DEFAULT;
    }
}

