/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.gui.screen.CursorOptionsScreen;
import io.github.fishstiz.minecraftcursor.gui.widget.MoreOptionsListWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorHotspotWidget;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import org.jetbrains.annotations.Nullable;

public class MoreOptionsScreen
extends class_437
implements CursorProvider {
    private static final int HOTSPOT_WIDGET_SIZE = 96;
    private final class_8132 layout = new class_8132((class_437)this);
    private final class_437 previousScreen;
    private final CursorManager cursorManager;
    @Nullable
    private final SelectedCursorHotspotWidget hotspotWidget;
    private final class_4185 doneButton = class_4185.method_46430((class_2561)class_5244.field_24334, btn -> this.method_25419()).method_46431();
    private MoreOptionsListWidget list;

    /*
     * Enabled aggressive block sorting
     */
    protected MoreOptionsScreen(class_437 previousScreen, CursorManager cursorManager) {
        super((class_2561)class_2561.method_43471((String)"minecraft-cursor.options.more"));
        this.previousScreen = previousScreen;
        this.cursorManager = cursorManager;
        if (previousScreen instanceof CursorOptionsScreen) {
            CursorOptionsScreen optionsScreen = (CursorOptionsScreen)previousScreen;
            if (optionsScreen.body != null) {
                this.hotspotWidget = new SelectedCursorHotspotWidget(96, optionsScreen.body.selectedCursorColumn);
                this.hotspotWidget.field_22764 = false;
                this.method_25429((class_364)this.hotspotWidget);
                return;
            }
        }
        this.hotspotWidget = null;
    }

    protected void method_25426() {
        if (this.list != null && this.list.isReloaded()) {
            this.method_25419();
        }
        this.layout.method_57726(this.field_22785, this.field_22793);
        this.list = (MoreOptionsListWidget)this.layout.method_48999((class_8021)new MoreOptionsListWidget(this.field_22787, this.field_22789, this.layout.method_57727(), this.layout.method_48998(), this.cursorManager));
        if (this.hotspotWidget != null) {
            this.hotspotWidget.setChangeEventListener(this.list::handleChangeHotspotWidget);
        }
        this.layout.method_48996((class_8021)this.doneButton);
        this.layout.method_48206(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        });
        this.refreshWidgetPositions();
    }

    protected void refreshWidgetPositions() {
        if (this.list != null) {
            this.layout.method_48222();
            this.list.method_57712(this.field_22789, this.layout);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.list == null || this.hotspotWidget == null) {
            return;
        }
        if (this.list.isEditingHotspot()) {
            int rowGap = this.list.getRowGap();
            int x = this.list.method_25342() - this.hotspotWidget.method_25368() - rowGap;
            int y = this.list.getYEntry(1) + rowGap / 2;
            this.hotspotWidget.method_48229(x, y);
            this.hotspotWidget.field_22764 = true;
            this.hotspotWidget.field_22763 = true;
            context.method_44379(x, this.layout.method_48998(), this.list.method_25342(), this.layout.method_48998() + this.layout.method_57727());
            this.hotspotWidget.method_25394(context, mouseX, mouseY, delta);
            context.method_44380();
        } else {
            this.hotspotWidget.field_22764 = false;
            this.hotspotWidget.field_22763 = false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void method_25419() {
        this.list.applyConfig();
        if (this.field_22787 == null) return;
        class_437 class_4372 = this.previousScreen;
        if (class_4372 instanceof CursorOptionsScreen) {
            CursorOptionsScreen options = (CursorOptionsScreen)class_4372;
            if (options.body != null) {
                CursorOptionsScreen optionsScreen = new CursorOptionsScreen(options.previousScreen, this.cursorManager);
                optionsScreen.selectCursor(options.getSelectedCursor());
                this.field_22787.method_1507((class_437)optionsScreen);
                return;
            }
        }
        this.field_22787.method_1507(this.previousScreen);
    }

    public CursorType getCursorType(double mouseX, double mouseY) {
        int headerHeight = this.layout.method_48998();
        if ((mouseY < (double)headerHeight || mouseY > (double)(headerHeight + this.layout.method_57727())) && mouseX > (double)(this.doneButton.method_46426() + this.doneButton.method_25368())) {
            return CursorType.DEFAULT_FORCE;
        }
        return CursorType.DEFAULT;
    }
}

