/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.screen.CursorOptionsScreen;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4264;
import net.minecraft.class_4265;
import net.minecraft.class_5250;
import net.minecraft.class_6379;
import net.minecraft.class_6382;

public class CursorListWidget
extends class_4265<CursorEntry> {
    private static final int ITEM_HEIGHT = 32;
    private static final int SCROLLBAR_OFFSET = 6;
    private static final int ROW_GAP = 1;
    private final CursorOptionsScreen optionsScreen;

    public CursorListWidget(class_310 client, int width, int height, int y, CursorOptionsScreen optionsScreen) {
        super(client, width + 6, height, y, 33);
        this.optionsScreen = optionsScreen;
        this.populateEntries();
    }

    public void populateEntries() {
        for (Cursor cursor : this.optionsScreen.getCursors()) {
            CursorEntry entry = new CursorEntry(cursor, this.method_46426(), this.method_46427() + this.field_22741 * this.method_25340(), this.field_22758 - 6, 32);
            this.method_25321((class_350.class_351)entry);
        }
    }

    public int method_25331() {
        return Math.max(0, this.method_25317() - (this.method_55443() - this.method_46427()) + 1 * this.method_25340() - 1);
    }

    protected int method_25329() {
        return this.method_55442() - 6;
    }

    protected void method_57713(class_332 context) {
    }

    public void method_57715(class_332 context) {
    }

    class CursorEntry
    extends class_4265.class_4266<CursorEntry> {
        public final CursorButtonWidget button;

        public CursorEntry(Cursor cursor, int x, int y, int width, int height) {
            this.button = new CursorButtonWidget(x, y, width, height, cursor);
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            this.button.method_46421(CursorListWidget.this.method_46426());
            this.button.method_46419(CursorListWidget.this.method_46427() + (CursorListWidget.this.field_22741 + 1) * index - (int)Math.round(CursorListWidget.this.method_25341()));
            this.button.method_25394(context, mouseX, mouseY, delta);
        }

        public List<? extends class_6379> method_37025() {
            return List.of(this.button);
        }

        public List<? extends class_364> method_25396() {
            return List.of(this.button);
        }
    }

    class CursorButtonWidget
    extends class_4264 {
        private static final String PREFIX_TEXT_KEY = "minecraft-cursor.options.cursor-type.";
        private static final int TEXTURE_SIZE = 16;
        private static final int PADDING_LEFT = 8;
        private static final int BACKGROUND_COLOR = 0x7F000000;
        private static final int TEXT_COLOR = -1;
        private static final int TEXT_DISABLED_COLOR = -11184811;
        private static final int BORDER_COLOR = -1;
        private final Cursor cursor;

        CursorButtonWidget(int x, int y, int width, int height, Cursor cursor) {
            super(x, y, width, height, (class_2561)class_2561.method_43473());
            this.cursor = cursor;
        }

        public void method_25306() {
            CursorListWidget.this.optionsScreen.selectCursor(this.cursor);
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            this.renderBox(context);
            this.renderTexture(context);
            this.renderMessage(context);
            context.method_49601(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), this.method_25367() || this.cursor == CursorListWidget.this.optionsScreen.getSelectedCursor() ? -1 : -16777216);
        }

        private void renderBox(class_332 context) {
            int x2 = this.method_46426() + this.method_25368();
            int y2 = this.method_46427() + this.method_25364();
            context.method_25294(this.method_46426(), this.method_46427(), x2, y2, 0x7F000000);
        }

        private void renderTexture(class_332 context) {
            int x = this.method_46426() + 8;
            int y = this.method_46427() + this.method_25364() / 2 - 8;
            CursorListWidget.this.optionsScreen.animationHelper.drawSprite(context, this.cursor, x, y, 16);
        }

        private void renderMessage(class_332 context) {
            class_5250 message = class_2561.method_43471((String)(PREFIX_TEXT_KEY + this.cursor.getType().getKey()));
            int color = this.cursor.isEnabled() ? -1 : -11184811;
            int x = this.method_46426() + 16 + 16;
            int endX = this.method_46426() + this.method_25368() - 6;
            int endY = this.method_46427() + this.method_25364();
            DrawUtil.drawScrollableTextLeftAlign(context, ((CursorListWidget)CursorListWidget.this).field_22740.field_1772, (class_2561)message, x, this.method_46427(), endX, endY, color);
        }

        protected void method_47399(class_6382 builder) {
        }
    }
}

