/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.CursorManager;
import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.cursor.AnimatedCursor;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorButtonWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorSliderWidget;
import io.github.fishstiz.minecraftcursor.gui.widget.SelectedCursorToggleWidget;
import io.github.fishstiz.minecraftcursor.util.DrawUtil;
import io.github.fishstiz.minecraftcursor.util.MouseEvent;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.ObjDoubleConsumer;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class MoreOptionsListWidget
extends class_4265<OptionEntry> {
    private static final CursorConfig.GlobalSettings GLOBAL = MinecraftCursor.CONFIG.getGlobal();
    private static final String GLOBAL_TOOLTIP_KEY = "minecraft-cursor.options.more.global.tooltip";
    private static final class_2561 GLOBAL_SETTINGS_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.more.global");
    private static final class_7919 ANIMATION_TOOLTIP = class_7919.method_47407((class_2561)class_2561.method_43471((String)"minecraft-cursor.options.more.animation.tooltip"));
    private static final class_2561 ANIMATION_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.more.animation");
    private static final class_7919 ADAPTIVE_CURSOR_TOOLTIP = class_7919.method_47407((class_2561)class_2561.method_43471((String)"minecraft-cursor.options.more.adapt.tooltip"));
    private static final class_2561 ADAPTIVE_CURSOR_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.more.adapt");
    private static final class_2561 ITEM_SLOT_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.item_slot");
    private static final class_2561 ITEM_GRAB_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.item_grab");
    private static final class_2561 CREATIVE_TABS_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.creative_tabs");
    private static final class_2561 ENCHANTMENTS_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.enchantments");
    private static final class_2561 STONECUTTER_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.stonecutter");
    private static final class_2561 BOOK_EDIT_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.book_edit");
    private static final class_2561 LOOM_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.loom");
    private static final class_2561 ADVANCEMENTS_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.advancements");
    private static final class_2561 WORLD_ICON_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.world");
    private static final class_2561 SERVER_ICON_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.server");
    private static final class_2561 RESOURCE_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.more.resource_pack");
    private static final class_2561 RESOURCE_RELOAD_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.more.resource_pack.reset");
    private static final class_2561 RESOURCE_RELOAD_TOOLTIP_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.more.resource_pack.reset.tooltip");
    private static final class_2561 COMPAT_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.more.compat");
    private static final class_2561 REMAP_TEXT = class_2561.method_43471((String)"minecraft-cursor.options.more.compat.remap_cursors");
    private static final class_7919 REMAP_TOOLTIP = class_7919.method_47407((class_2561)class_2561.method_43471((String)"minecraft-cursor.options.more.compat.remap_cursors.tooltip"));
    private static final int BUTTON_WIDTH = 40;
    private static final int ITEM_HEIGHT = 20;
    private static final int ROW_GAP = 6;
    private final CursorManager cursorManager;
    private final List<ToggleEntry> adaptiveOptions = new ArrayList<ToggleEntry>();
    private final SliderEntry xhotEntry = this.createSliderEntry(CursorOptionsWidget.XHOT_TEXT, "px", 0.0, 31.0, 1.0, GLOBAL::isXHotActive, GLOBAL::setXhotActive, GLOBAL::getXHot, GLOBAL::setXHotDouble, CursorConfig.Settings::getXHot, Cursor::setXHot);
    private final SliderEntry yhotEntry = this.createSliderEntry(CursorOptionsWidget.YHOT_TEXT, "px", 0.0, 31.0, 1.0, GLOBAL::isYHotActive, GLOBAL::setYhotActive, GLOBAL::getYHot, GLOBAL::setYHotDouble, CursorConfig.Settings::getYHot, Cursor::setYHot);
    private boolean reloaded = false;

    public MoreOptionsListWidget(class_310 client, int width, int height, int y, CursorManager cursorManager) {
        super(client, width, height, y, 26);
        this.cursorManager = cursorManager;
        this.addGlobalOptions();
        this.addAdaptiveOptions();
        this.addModCompatOptions();
        this.addResourcePackOptions();
    }

    private void addGlobalOptions() {
        this.method_25321((class_350.class_351)new TitleEntry(GLOBAL_SETTINGS_TEXT));
        this.method_25321((class_350.class_351)new ToggleEntry(this, ANIMATION_TEXT, this.cursorManager.isAnimated(), this.cursorManager.hasAnimations(), ANIMATION_TOOLTIP, this::toggleAnimations));
        this.method_25321((class_350.class_351)this.createSliderEntry(CursorOptionsWidget.SCALE_TEXT, "", 0.5, 3.0, 0.05, GLOBAL::isScaleActive, GLOBAL::setScaleActive, GLOBAL::getScale, GLOBAL::setScale, CursorConfig.Settings::getScale, Cursor::setScale));
        this.method_25321((class_350.class_351)this.xhotEntry);
        this.method_25321((class_350.class_351)this.yhotEntry);
    }

    private void addAdaptiveOptions() {
        boolean isAdaptive = this.cursorManager.isAdaptive();
        this.method_25321((class_350.class_351)new TitleEntry(ADAPTIVE_CURSOR_TEXT));
        this.method_25321((class_350.class_351)new ToggleEntry(this, CursorOptionsWidget.ENABLED_TEXT, isAdaptive, true, ADAPTIVE_CURSOR_TOOLTIP, this::toggleAdaptive));
        this.addAdaptiveEntry(ITEM_SLOT_TEXT, MinecraftCursor.CONFIG.isItemSlotEnabled(), isAdaptive, MinecraftCursor.CONFIG::setItemSlotEnabled);
        this.addAdaptiveEntry(ITEM_GRAB_TEXT, MinecraftCursor.CONFIG.isItemGrabbingEnabled(), isAdaptive, MinecraftCursor.CONFIG::setItemGrabbingEnabled);
        this.addAdaptiveEntry(CREATIVE_TABS_TEXT, MinecraftCursor.CONFIG.isCreativeTabsEnabled(), isAdaptive, MinecraftCursor.CONFIG::setCreativeTabsEnabled);
        this.addAdaptiveEntry(ENCHANTMENTS_TEXT, MinecraftCursor.CONFIG.isEnchantmentsEnabled(), isAdaptive, MinecraftCursor.CONFIG::setEnchantmentsEnabled);
        this.addAdaptiveEntry(STONECUTTER_TEXT, MinecraftCursor.CONFIG.isStonecutterRecipesEnabled(), isAdaptive, MinecraftCursor.CONFIG::setStonecutterRecipesEnabled);
        this.addAdaptiveEntry(BOOK_EDIT_TEXT, MinecraftCursor.CONFIG.isBookEditEnabled(), isAdaptive, MinecraftCursor.CONFIG::setBookEditEnabled);
        this.addAdaptiveEntry(LOOM_TEXT, MinecraftCursor.CONFIG.isLoomPatternsEnabled(), isAdaptive, MinecraftCursor.CONFIG::setLoomPatternsEnabled);
        this.addAdaptiveEntry(ADVANCEMENTS_TEXT, MinecraftCursor.CONFIG.isAdvancementTabsEnabled(), isAdaptive, MinecraftCursor.CONFIG::setAdvancementTabsEnabled);
        this.addAdaptiveEntry(WORLD_ICON_TEXT, MinecraftCursor.CONFIG.isWorldIconEnabled(), isAdaptive, MinecraftCursor.CONFIG::setWorldIconEnabled);
        this.addAdaptiveEntry(SERVER_ICON_TEXT, MinecraftCursor.CONFIG.isServerIconEnabled(), isAdaptive, MinecraftCursor.CONFIG::setServerIconEnabled);
    }

    private void addModCompatOptions() {
        this.method_25321((class_350.class_351)new TitleEntry(COMPAT_TEXT));
        this.method_25321((class_350.class_351)new ToggleEntry(this, REMAP_TEXT, MinecraftCursor.CONFIG.isRemapCursorsEnabled(), true, REMAP_TOOLTIP, MinecraftCursor.CONFIG::setRemapCursorsEnabled));
    }

    private void addResourcePackOptions() {
        this.method_25321((class_350.class_351)new TitleEntry(RESOURCE_TEXT));
        this.method_25321((class_350.class_351)new FullButtonEntry(RESOURCE_RELOAD_TEXT, RESOURCE_RELOAD_TOOLTIP_TEXT, this::reloadConfiguration));
    }

    private void reloadConfiguration() {
        MinecraftCursor.CONFIG.set_hash(String.valueOf(Math.random()));
        this.field_22740.method_1521().thenRun(() -> {
            this.reloaded = true;
        });
    }

    public boolean isReloaded() {
        return this.reloaded;
    }

    private void addAdaptiveEntry(class_2561 label, boolean isEnabled, boolean active, Consumer<Boolean> onPress) {
        ToggleEntry entry = new ToggleEntry(this, label, isEnabled, active, onPress);
        this.adaptiveOptions.add(entry);
        this.method_25321((class_350.class_351)entry);
    }

    private SliderEntry createSliderEntry(class_2561 text, String suffix, double min, double max, double step, BooleanSupplier activeGetter, BooleanConsumer activeSetter, DoubleSupplier valueGetter, DoubleConsumer valueSetter, ToDoubleFunction<CursorConfig.Settings> settingsValueGetter, ObjDoubleConsumer<Cursor> cursorAction) {
        Runnable updateCursors = () -> this.cursorManager.getLoadedCursors().forEach(cursor -> {
            double value = activeGetter.getAsBoolean() ? valueGetter.getAsDouble() : settingsValueGetter.applyAsDouble(MinecraftCursor.CONFIG.getOrCreateCursorSettings(cursor.getType()));
            cursorAction.accept((Cursor)cursor, value);
        });
        DoubleConsumer handleChange = value -> {
            valueSetter.accept(value);
            cursorAction.accept(this.cursorManager.getCurrentCursor(), value);
        };
        BooleanConsumer handleToggle = active -> {
            activeSetter.accept(active);
            updateCursors.run();
        };
        SliderEntry.Slider slider = new SliderEntry.Slider(text, suffix, valueGetter.getAsDouble(), min, max, step, handleChange::accept);
        SliderEntry.Toggle toggle = new SliderEntry.Toggle(CursorOptionsWidget.ENABLED_TEXT, activeGetter.getAsBoolean(), MoreOptionsListWidget.getSettingTooltip(text), (Consumer<Boolean>)handleToggle);
        return new SliderEntry(slider, toggle, updateCursors);
    }

    public void handleChangeHotspotWidget(MouseEvent mouseEvent, int xhot, int yhot) {
        boolean applyX = GLOBAL.isXHotActive();
        boolean applyY = GLOBAL.isYHotActive();
        if (applyX) {
            GLOBAL.setXHot(xhot);
            this.xhotEntry.sliderWidget.setTranslatedValue(xhot);
        }
        if (applyY) {
            GLOBAL.setYHot(yhot);
            this.yhotEntry.sliderWidget.setTranslatedValue(yhot);
        }
        if (applyX && applyY) {
            this.cursorManager.getCurrentCursor().setHotspots(xhot, yhot);
        } else if (applyX) {
            this.cursorManager.getCurrentCursor().setXHot(xhot);
        } else if (applyY) {
            this.cursorManager.getCurrentCursor().setYHot(yhot);
        }
        if (mouseEvent == MouseEvent.RELEASE) {
            this.applyHotspotsToAll();
        }
    }

    private void applyHotspotsToAll() {
        boolean applyX = GLOBAL.isXHotActive();
        boolean applyY = GLOBAL.isYHotActive();
        if (applyX && applyY) {
            this.cursorManager.getLoadedCursors().forEach(cursor -> cursor.setHotspots(GLOBAL.getXHot(), GLOBAL.getYHot()));
        } else if (applyX) {
            this.cursorManager.getLoadedCursors().forEach(cursor -> cursor.setXHot(GLOBAL.getXHot()));
        } else if (applyY) {
            this.cursorManager.getLoadedCursors().forEach(cursor -> cursor.setYHot(GLOBAL.getYHot()));
        }
    }

    private void applyScaleToAll() {
        if (GLOBAL.isScaleActive()) {
            this.cursorManager.getLoadedCursors().forEach(cursor -> cursor.setScale(GLOBAL.getScale()));
        }
    }

    public void applyConfig() {
        this.applyScaleToAll();
        this.applyHotspotsToAll();
    }

    private void toggleAnimations(boolean isAnimated) {
        this.cursorManager.setIsAnimated(isAnimated);
        MinecraftCursor.CONFIG.getSettings().forEach((key, settings) -> {
            if (this.cursorManager.getCursor((String)key) instanceof AnimatedCursor) {
                settings.setAnimated(isAnimated);
            }
        });
    }

    private void toggleAdaptive(boolean isEnabled) {
        this.adaptiveOptions.forEach(option -> {
            ((ToggleWidget)option.button).field_22763 = isEnabled;
            ((ToggleWidget)option.button).setValue(isEnabled);
        });
        this.cursorManager.setIsAdaptive(isEnabled);
        MinecraftCursor.CONFIG.getSettings().forEach((key, settings) -> {
            if (key.equals(CursorType.DEFAULT.getKey())) {
                return;
            }
            settings.update(settings.getScale(), settings.getXHot(), settings.getYHot(), isEnabled);
        });
    }

    public int getYEntry(int index) {
        return this.method_46427() + this.field_22741 * index + 6 - (int)Math.round(this.method_25341());
    }

    public int getRowGap() {
        return 6;
    }

    public boolean isEditingHotspot() {
        return !(!GLOBAL.isXHotActive() && !GLOBAL.isYHotActive() || !this.xhotEntry.method_25370() && !this.yhotEntry.method_25370());
    }

    public ToggleWidget createToggleWidget(boolean defaultValue, class_7919 tooltip, Consumer<Boolean> onPress) {
        return new ToggleWidget(this.method_31383() - 40, this.method_46427() + this.field_22741 * this.method_25340() + 6, 40, this.field_22741 - 6, defaultValue, tooltip, onPress);
    }

    public static class_7919 getSettingTooltip(class_2561 settingText) {
        return class_7919.method_47407((class_2561)class_2561.method_43469((String)GLOBAL_TOOLTIP_KEY, (Object[])new Object[]{settingText}));
    }

    public class SliderEntry
    extends ToggleEntry {
        private final SelectedCursorSliderWidget sliderWidget;

        public SliderEntry(Slider slider, Toggle toggle, Runnable onRelease) {
            super(MoreOptionsListWidget.this, (class_2561)class_2561.method_43473(), toggle.value, true, toggle.tooltip, toggle.toggleFunction);
            this.sliderWidget = new SelectedCursorSliderWidget(slider.label, slider.value, slider.min, slider.max, slider.step, slider.suffix, slider.applyFunction, onRelease);
        }

        @Override
        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            super.method_25343(context, index, y, x, entryWidth, entryHeight, mouseX, mouseY, hovered, tickDelta);
            this.sliderWidget.field_22763 = ((ToggleWidget)this.button).value;
            this.sliderWidget.method_48229(x - 3, MoreOptionsListWidget.this.getYEntry(index));
            this.sliderWidget.method_55445(((ToggleWidget)this.button).method_46426() - x - 6, 20);
            this.sliderWidget.method_48579(context, mouseX, mouseY, tickDelta);
        }

        @Override
        protected List<class_339> getChildren() {
            return List.of(this.sliderWidget, this.button);
        }

        public record Toggle(class_2561 label, boolean value, class_7919 tooltip, Consumer<Boolean> toggleFunction) {
        }

        public record Slider(class_2561 label, String suffix, double value, double min, double max, double step, Consumer<Double> applyFunction) {
        }
    }

    public class TitleEntry
    extends OptionEntry {
        public TitleEntry(class_2561 label) {
            super((class_2561)class_2561.method_43473().method_10852(label).method_27695(new class_124[]{class_124.field_1067, class_124.field_1054}));
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int itemY = Math.round((float)y + (float)entryHeight / 3.0f);
            int titleX = x + (MoreOptionsListWidget.this.method_25322() / 2 - ((MoreOptionsListWidget)MoreOptionsListWidget.this).field_22740.field_1772.method_27525((class_5348)this.label) / 2);
            context.method_51439(((MoreOptionsListWidget)MoreOptionsListWidget.this).field_22740.field_1772, this.label, titleX, itemY, -1, false);
        }

        @Override
        protected List<class_339> getChildren() {
            return List.of();
        }
    }

    public class ToggleEntry
    extends LabeledButtonEntry<ToggleWidget> {
        public ToggleEntry(MoreOptionsListWidget this$0, class_2561 label, boolean defaultValue, boolean active, Consumer<Boolean> onPress) {
            this(this$0, label, defaultValue, active, null, onPress);
        }

        public ToggleEntry(MoreOptionsListWidget this$0, class_2561 label, boolean defaultValue, @Nullable boolean active, class_7919 tooltip, Consumer<Boolean> onPress) {
            super(label, () -> this$0.createToggleWidget(defaultValue, tooltip, onPress));
            ((ToggleWidget)this.button).field_22763 = active;
        }
    }

    public class FullButtonEntry
    extends OptionEntry {
        private final SelectedCursorButtonWidget button;

        protected FullButtonEntry(class_2561 label, class_2561 tooltipText, Runnable onPress) {
            super(label);
            this.button = new SelectedCursorButtonWidget(label, onPress);
            this.button.method_55445(MoreOptionsListWidget.this.method_25322(), 20);
            this.button.method_47400(class_7919.method_47407((class_2561)tooltipText));
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.button.method_48229(MoreOptionsListWidget.this.method_25342(), MoreOptionsListWidget.this.getYEntry(index));
            this.button.method_25394(context, mouseX, mouseY, tickDelta);
        }

        @Override
        protected List<class_339> getChildren() {
            return List.of(this.button);
        }
    }

    public static class ToggleWidget
    extends SelectedCursorToggleWidget {
        protected ToggleWidget(int x, int y, int width, int height, boolean defaultValue, @Nullable class_7919 tooltip, Consumer<Boolean> onPress) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), defaultValue, onPress);
            if (tooltip != null) {
                this.method_47400(tooltip);
            }
        }

        @Override
        protected void updateMessage() {
            this.method_25355(this.value ? class_5244.field_24332 : class_5244.field_24333);
        }
    }

    public class LabeledButtonEntry<T extends class_339>
    extends OptionEntry {
        protected final T button;

        protected LabeledButtonEntry(class_2561 label, Supplier<T> buttonFactory) {
            super(label);
            this.button = (class_339)buttonFactory.get();
            this.button.method_55445(40, 20);
        }

        public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.button.method_46421(MoreOptionsListWidget.this.method_31383() - 40);
            this.button.method_46419(MoreOptionsListWidget.this.getYEntry(index));
            this.button.method_25394(context, mouseX, mouseY, tickDelta);
            int textEndX = this.button.method_46426() - 6;
            int textEndY = y + entryHeight;
            int textColor = -1;
            DrawUtil.drawScrollableTextLeftAlign(context, ((MoreOptionsListWidget)MoreOptionsListWidget.this).field_22740.field_1772, this.label, x, y, textEndX, textEndY, textColor);
        }

        @Override
        protected List<class_339> getChildren() {
            return List.of(this.button);
        }
    }

    public static abstract class OptionEntry
    extends class_4265.class_4266<OptionEntry> {
        protected final class_2561 label;

        protected OptionEntry(class_2561 label) {
            this.label = label;
        }

        public List<? extends class_6379> method_37025() {
            return this.getChildren();
        }

        public List<? extends class_364> method_25396() {
            return this.getChildren();
        }

        protected abstract List<class_339> getChildren();
    }
}

