/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.widget;

import io.github.fishstiz.minecraftcursor.MinecraftCursor;
import io.github.fishstiz.minecraftcursor.api.CursorProvider;
import io.github.fishstiz.minecraftcursor.api.CursorType;
import io.github.fishstiz.minecraftcursor.config.CursorConfig;
import io.github.fishstiz.minecraftcursor.gui.widget.CursorOptionsWidget;
import io.github.fishstiz.minecraftcursor.util.CursorTypeUtil;
import io.github.fishstiz.minecraftcursor.util.MouseEvent;
import java.util.function.BiConsumer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6382;

public class SelectedCursorHotspotWidget
extends class_339
implements CursorProvider {
    private static final CursorConfig.GlobalSettings global = MinecraftCursor.CONFIG.getGlobal();
    private static final class_2960 BACKGROUND = class_2960.method_60655((String)"minecraft-cursor", (String)"textures/gui/hotspot_background.png");
    private static final int CURSOR_SIZE = 32;
    private static final int RULER_COLOR = -65536;
    private static final int OVERRIDE_RULER_COLOR = -16711936;
    private final CursorOptionsWidget options;
    private boolean rulerRendered = true;
    private float rulerAlpha = 1.0f;
    private MouseEventListener changeEventListener;

    public SelectedCursorHotspotWidget(int size, CursorOptionsWidget options) {
        super(options.method_46426(), options.method_46427(), size, size, (class_2561)class_2561.method_43473());
        this.options = options;
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25290(BACKGROUND, this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.field_22758, this.field_22759, this.field_22758, this.field_22759);
        if (!this.field_22763) {
            context.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), -1358954496);
        }
        this.drawCursorTexture(context);
        this.renderRuler(context, mouseX, mouseY);
        context.method_49601(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), -16777216);
    }

    private void drawCursorTexture(class_332 context) {
        this.options.parent().animationHelper.drawSprite(context, this.options.parent().getSelectedCursor(), this.method_46426(), this.method_46427(), this.field_22758);
    }

    private void renderRuler(class_332 context, int mouseX, int mouseY) {
        if (this.method_25405(mouseX, mouseY)) {
            this.setRulerRendered(true, false);
        }
        this.rulerAlpha = class_3532.method_16439((float)0.3f, (float)this.rulerAlpha, (float)(this.rulerRendered ? 1.0f : 0.0f));
        if (this.rulerAlpha <= 0.01f) {
            return;
        }
        boolean isGlobalX = global.isXHotActive();
        boolean isGlobalY = global.isYHotActive();
        int xhot = isGlobalX ? global.getXHot() : (int)this.options.xhotSlider.getTranslatedValue();
        int yhot = isGlobalY ? global.getYHot() : (int)this.options.yhotSlider.getTranslatedValue();
        int rulerSize = this.getRulerSize();
        int xhotX1 = this.method_46426() + xhot * rulerSize;
        int xhotX2 = this.method_46426() + xhot * rulerSize + rulerSize;
        int yhotY1 = this.method_46427() + yhot * rulerSize;
        int yhotY2 = this.method_46427() + yhot * rulerSize + rulerSize;
        int alpha = (int)(this.rulerAlpha * 255.0f);
        int blendedColorX = this.getBlendedColor(isGlobalX ? -16711936 : -65536, alpha);
        int blendedColorY = this.getBlendedColor(isGlobalY ? -16711936 : -65536, alpha);
        if (isGlobalX && !isGlobalY || isGlobalX == isGlobalY) {
            context.method_25294(this.method_46426(), yhotY1, this.method_55442(), yhotY2, blendedColorY);
            context.method_25294(xhotX1, this.method_46427(), xhotX2, this.method_55443(), blendedColorX);
        } else {
            context.method_25294(xhotX1, this.method_46427(), xhotX2, this.method_55443(), blendedColorX);
            context.method_25294(this.method_46426(), yhotY1, this.method_55442(), yhotY2, blendedColorY);
        }
    }

    public int getBlendedColor(int color, int alpha) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    public void method_25348(double mouseX, double mouseY) {
        this.setHotspots(MouseEvent.CLICK, mouseX, mouseY);
    }

    protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.setHotspots(MouseEvent.DRAG, mouseX, mouseY);
    }

    public void setHotspots(MouseEvent mouseEvent, double mouseX, double mouseY) {
        if (this.changeEventListener != null) {
            int rulerSize = this.getRulerSize();
            int x = ((int)mouseX - this.method_46426()) / rulerSize;
            int y = ((int)mouseY - this.method_46427()) / rulerSize;
            this.changeEventListener.onChange(mouseEvent, x, y);
        }
        this.setRulerRendered(true, true);
    }

    private int getRulerSize() {
        return this.method_25368() / 32;
    }

    public void setRulerRendered(boolean rulerRendered, boolean immediate) {
        if (immediate) {
            this.rulerAlpha = rulerRendered ? 1.0f : 0.0f;
        }
        this.rulerRendered = rulerRendered;
    }

    public CursorType getCursorType(double mouseX, double mouseY) {
        if (!this.field_22763) {
            return CursorType.DEFAULT;
        }
        if (this.method_25370() && (CursorTypeUtil.isLeftClickHeld() || CursorTypeUtil.isGrabbing())) {
            return CursorType.GRABBING;
        }
        return CursorType.POINTER;
    }

    public void setChangeEventListener(BiConsumer<Integer, Integer> changeEventListener) {
        this.setChangeEventListener((MouseEvent mouseEvent, int x, int y) -> changeEventListener.accept(x, y));
    }

    public void setChangeEventListener(MouseEventListener changeEventListener) {
        this.changeEventListener = changeEventListener;
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764 && mouseX >= (double)this.method_46426() && mouseY >= (double)this.method_46427() && mouseX < (double)this.method_55442() && mouseY < (double)this.method_55443();
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.method_25370()) {
            this.setHotspots(MouseEvent.RELEASE, mouseX, mouseY);
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    protected void method_47399(class_6382 builder) {
    }

    @FunctionalInterface
    public static interface MouseEventListener {
        public void onChange(MouseEvent var1, int var2, int var3);
    }
}

