/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.compat;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.platform.cursor.CursorType;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.compat.CursorStateTrackerImpl;
import io.github.fishstiz.cursors_extended.compat.ModCursor;
import org.jetbrains.annotations.Nullable;

public interface CursorStateTracker {
    public static final CursorStateTracker DEFAULT = new CursorStateTracker(){};

    default public void trackCursor(ModCursor cursor) {
        CursorStateTrackerImpl.get().trackCursor(cursor);
    }

    default public void untrackCursor(ModCursor cursor) {
    }

    default public boolean isTracking() {
        return false;
    }

    default public void resetCursor(long window, String source) {
        CursorStateTrackerImpl.get().resetCursor(window, source);
    }

    default public void setCursor(long window, ModCursor cursor) {
        CursorStateTrackerImpl.get().setCursor(window, cursor);
    }

    @Nullable
    default public ModCursor getCursor(long handle) {
        return null;
    }

    default public CursorType getCurrentCursor(long window) {
        return CursorType.DEFAULT;
    }

    public static CursorStateTracker get() {
        return CursorStateTrackerImpl.getOrDefault();
    }

    public static StackWalker getStackWalker() {
        return CursorStateTrackerImpl.getStackWalker();
    }

    public static void syncWithMinecraft(long window, CursorType cursorType) {
        Window minecraftWindow = CursorsExtended.getInstance().getDisplay().getWindow();
        if (window == minecraftWindow.handle()) {
            minecraftWindow.currentCursor = cursorType;
        }
    }
}

