/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.cursors_extended.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.fishstiz.cursors_extended.CursorsExtended;
import io.github.fishstiz.cursors_extended.config.CursorMetadata;
import io.github.fishstiz.cursors_extended.cursor.AnimationMode;
import io.github.fishstiz.cursors_extended.util.SettingsUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Supplier;
import net.minecraft.server.packs.resources.Resource;

public class JsonLoader {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(CursorMetadata.Animation.Frame.class, (Object)new MetaAnimationFrameDeserializer()).registerTypeAdapter(CursorMetadata.CursorSettings.class, (Object)new MetaCursorSettingsDeserializer()).registerTypeAdapter(AnimationMode.class, (Object)new AnimationModeDeserializer()).setPrettyPrinting().create();

    private JsonLoader() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T fromResource(Class<T> clazz, Resource resource) {
        try (InputStream stream = resource.open();){
            T t = JsonLoader.fromStream(clazz, stream);
            return t;
        }
        catch (IOException e) {
            CursorsExtended.LOGGER.error("[cursors-extended] Failed to open resource: {}", (Object)resource);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T fromStream(Class<T> clazz, InputStream stream) {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            Serializable serializable = (Serializable)GSON.fromJson((Reader)reader, clazz);
            return (T)serializable;
        }
        catch (IOException e) {
            CursorsExtended.LOGGER.error("[cursors-extended] Failed to load file: {}", clazz);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T loadOrDefault(Class<T> clazz, Path path, Supplier<T> defaultSupplier) {
        path = JsonLoader.ensureJsonSuffix(path);
        try (BufferedReader reader = Files.newBufferedReader(path);){
            Serializable serializable = (Serializable)GSON.fromJson((Reader)reader, clazz);
            return (T)serializable;
        }
        catch (NoSuchFileException e) {
            Serializable obj = (Serializable)defaultSupplier.get();
            CursorsExtended.LOGGER.info("[cursors-extended] Creating file at '{}'...", (Object)path);
            JsonLoader.save(path, obj);
            return (T)obj;
        }
        catch (IOException e) {
            CursorsExtended.LOGGER.error("[cursors-extended] Failed to load file at '{}'", (Object)path);
            return (T)((Serializable)defaultSupplier.get());
        }
    }

    public static void save(Path path, Serializable obj) {
        path = JsonLoader.ensureJsonSuffix(path);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            GSON.toJson((Object)obj, (Appendable)writer);
        }
        catch (IOException e) {
            CursorsExtended.LOGGER.error("[cursors-extended] Failed to save file at '{}'", (Object)path);
        }
    }

    private static Path ensureJsonSuffix(Path path) {
        String fileName = path.getFileName().toString();
        if (!fileName.endsWith(".json")) {
            path = path.resolveSibling(fileName + ".json");
        }
        return path;
    }

    private static class MetaAnimationFrameDeserializer
    implements JsonDeserializer<CursorMetadata.Animation.Frame> {
        private MetaAnimationFrameDeserializer() {
        }

        public CursorMetadata.Animation.Frame deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isNumber()) {
                return new CursorMetadata.Animation.Frame(json.getAsInt(), 0);
            }
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                int index = obj.has("index") ? obj.get("index").getAsInt() : 0;
                int time = obj.has("time") ? obj.get("time").getAsInt() : 0;
                return new CursorMetadata.Animation.Frame(index, time);
            }
            throw new JsonParseException("Invalid Frame format");
        }
    }

    private static class MetaCursorSettingsDeserializer
    implements JsonDeserializer<CursorMetadata.CursorSettings> {
        private MetaCursorSettingsDeserializer() {
        }

        public CursorMetadata.CursorSettings deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            if (!json.isJsonObject()) {
                throw new JsonParseException("Expected JsonObject");
            }
            JsonObject obj = json.getAsJsonObject();
            boolean enabled = obj.has("enabled") ? obj.get("enabled").getAsBoolean() : true;
            float scale = obj.has("scale") ? obj.get("scale").getAsFloat() : 1.0f;
            int xhot = obj.has("xhot") ? obj.get("xhot").getAsInt() : 0;
            int yhot = obj.has("yhot") ? obj.get("yhot").getAsInt() : 0;
            Boolean animated = obj.has("animated") ? Boolean.valueOf(obj.get("animated").getAsBoolean()) : SettingsUtil.ANIMATED;
            return new CursorMetadata.CursorSettings(enabled, scale, xhot, yhot, animated);
        }
    }

    private static class AnimationModeDeserializer
    implements JsonDeserializer<AnimationMode> {
        private AnimationModeDeserializer() {
        }

        public AnimationMode deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return AnimationMode.getOrDefault(json.getAsString());
        }
    }
}

